# -*- coding: utf-8 -*-

# ==============================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ==============================================================================

"""Utilities on strings.
"""

import sys
import os

from utils import get_encoding


def print3(*args, **kwargs):
   """Replace print statement, similar to the print function of python3.0 :
         print3([object1...], sep=' ', end='\n', file=sys.stdout, encoding=None)
   encoding argument does not exist on python3.0.
   """
   sep = kwargs.get('sep', ' ')
   end = kwargs.get('end', '\n')
   file = kwargs.get('file', sys.stdout)
   encoding = kwargs.get('encoding', file.encoding)
   values = [convert(arg_i, encoding=encoding) for arg_i in args]
   file.write(sep.join(values) + end)


def to_unicode(string):
   """
   Try to convert string into a unicode string
   """
   for encoding in ('utf-8', 'iso-8859-15', 'cp1252'):
      try:
         return unicode(string, encoding)
      except UnicodeDecodeError:
         pass
   return unicode(string, 'utf-8', 'replace')


def from_unicode(ustring, encoding, errors='replace'):
   """
   Try to encode a unicode string using encoding.
   """
   try:
      return ustring.encode(encoding)
   except UnicodeError:
      pass
   return ustring.encode(encoding, errors)


def convert(content, encoding=None, errors='replace'):
   """
   Convert content using encoding or default encoding if None.
   """
   if type(content) not in (str, unicode):
      content = unicode(content)
   if type(content) == str:
      content = to_unicode(content)
   return from_unicode(content, encoding or get_encoding(), errors)


def indent(text, prefix):
   """
   Add `prefix` before each line of `text`.
   """
   l_s = [prefix+line for line in text.split(os.linesep)]
   return os.linesep.join(l_s)


def cut_long_lines(txt, maxlen, sep=os.linesep,
                   l_separ=(' ', ',', ';', '.', ':')):
   """
   Coupe les morceaux de `txt` (isolés avec `sep`) de plus de `maxlen`
   caractères.
   On utilise successivement les séparateurs de `l_separ`.
   """
   l_lines = txt.split(sep)
   newlines = []
   for line in l_lines:
      if len(line) > maxlen:
         l_sep = list(l_separ)
         if len(l_sep) == 0:
            newlines.extend(force_split(line, maxlen))
            continue
         else:
            line = cut_long_lines(line, maxlen, l_sep[0], l_sep[1:])
            line = maximize_lines(line, maxlen, l_sep[0])
         newlines.extend(line)
      else:
         newlines.append(line)
   # au plus haut niveau, on assemble le texte
   if sep == os.linesep:
      newlines = os.linesep.join(newlines)
   return newlines

