#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import time
import unittest

from common import dict_conf, execcmd, tmpdir
from data   import server_export

from asrun.calcul import parse_submission_result
from asrun.job    import parse_actu_result, parse_tail_result
from asrun.run    import AsRunFactory
from asrun.profil import ASTER_PROFIL
from asrun.calcul import ASTER_CALCUL



class TestServerFunctions(unittest.TestCase):

    def setUp(self):
        self.export = os.path.join(tmpdir, "server.export")
        open(self.export, "w").write(server_export % dict_conf)


    def test01_from_cmdline(self):
        cmd = dict_conf["as_run"] + ["--serv", self.export]
        iret, out = execcmd(cmd, "server.1", return_output=True)
        nomjob = "server_cmdline"
        assert iret == 0
        jobid, queue = parse_submission_result(out)
        assert jobid.strip() != ""
        assert jobid.strip().isdigit()
        
        time.sleep(0.2)
        cmd = dict_conf["as_run"] + ["--actu", jobid, nomjob, "interactif"]
        iret, out = execcmd(cmd, "server.2", return_output=True)
        assert iret == 0
        etat, diag, node, tcpu, wrk, queue = parse_actu_result(out)
        assert etat == "RUN", etat
        
        ftail = os.path.join(tmpdir, "server.3.tail")
        cmd = dict_conf["as_run"] + ["--tail", jobid, nomjob, "interactif", ftail, "10"]
        iret, out = execcmd(cmd, "server.3", return_output=True)
        assert iret == 0
        job, jobid_, etat, diag = parse_tail_result(out)
        assert etat == "RUN", etat
        
        time.sleep(8)
        cmd = cmd = dict_conf["as_run"] + ["--actu", jobid, nomjob, "interactif"]
        iret, out = execcmd(cmd, "server.4", return_output=True)
        assert iret == 0
        etat, diag, node, tcpu, wrk, queue = parse_actu_result(out)
        assert etat == "ENDED", etat
        assert diag == "OK", diag
        
        cmd = dict_conf["as_run"] + ["--del", jobid, nomjob, "interactif"]
        iret = execcmd(cmd, "server.5")
        assert iret == 0


    def test02_using_api(self):
        run = AsRunFactory()
        prof = ASTER_PROFIL(run=run, filename=self.export)
        # change job name and job number
        prof['nomjob'] = "server_api"
        calc = ASTER_CALCUL(run, prof=prof, pid=run.get_pid())
        jret, out = calc.start()
        assert jret == 0, "submission problem : %s" % out
        
        time.sleep(0.2)
        etat, diag, node, tcpu, wrk, queue = calc.get_state()
        assert etat == "RUN", etat
        
        etat, diag, s_out = calc.tail(expression='CODE_ASTER')
        assert etat == "RUN", etat
        
        calc.wait()
        
        etat, diag, node, tcpu, wrk, queue = calc.get_state()
        assert etat == "ENDED", etat
        assert diag == "OK", diag
        assert run.GetGrav(calc.diag) == 0
        assert os.path.isfile(calc.flash('o'))
        calc.kill()



if __name__ == "__main__":
    unittest.main()

