#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import re
import time
import unittest

from common import dict_conf, execcmd, tmpdir
from data   import study_dvp_export

import asrun
from asrun.run          import AsRunFactory
from asrun.profil       import ASTER_PROFIL
from asrun.calcul       import ASTER_CALCUL


class TestUseDvpt(unittest.TestCase):

    def test01_using_api(self):
        export = os.path.join(tmpdir, "study_dvp.export")
        open(export, "w").write(study_dvp_export % dict_conf)
        run = AsRunFactory()
        prof = ASTER_PROFIL(run=run, filename=export)

        calc = ASTER_CALCUL(run, prof=prof, pid=run.get_pid())
        jret, out = calc.start()
        calc.wait()
        assert run.GetGrav(calc.diag) == 1
        assert os.path.isfile(calc.flash('o'))
        output = open(calc.flash('o'), "r").read()
        assert len(re.findall("^ *MCTEST_CAPY", output, re.M)) == 1, calc.flash('o')
        calc.kill()


if __name__ == "__main__":
    unittest.main()

