#include "tank.h"
#include "team.h"
#include "player.h"

// check to see if a team has won.
int Team_Won(ENVIRONMENT *env)
{
   bool all_jedi = true;
   bool all_sith = true;
   TANK *current_tank;
   double my_team;
   int tank_count = 0;

   current_tank = (TANK *) env->getNextOfClass (TANK_CLASS, &tank_count);
   tank_count++;
   while (current_tank)
   {
      my_team = current_tank->player->team;
      if ( (my_team == TEAM_JEDI) || (my_team == TEAM_NEUTRAL) )
         all_sith = false;

      if ( (my_team == TEAM_SITH) || (my_team == TEAM_NEUTRAL) )
         all_jedi = false;

      current_tank = (TANK *) env->getNextOfClass (TANK_CLASS, &tank_count);
      tank_count++;
   }

   if (all_jedi) return JEDI_WIN;
   else if (all_sith) return SITH_WIN;
   else return NO_WIN;
}

