#!/usr/bin/python2.6
# -*- mode: python; coding: utf-8 -*-

# atheist
#
# Copyright (C) 2009,2010 David Villa Alises
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import signal
import sys
import time


import atheist
from atheist.manager import *

Log = atheist.Log

def main(argv):

    if not os.path.exists(atheist.const.ATHEIST_TMP):
        os.mkdir(atheist.const.ATHEIST_TMP)

    mgr = Manager(argv[1:])
    mgr.load()

    if mgr.config.describe:
        for t in mgr.itertasks():
            print(t.describe().encode('utf-8'))
        return

    if mgr.config.clean_only:
        atheist.clean_generated()
        return

    if mgr.config.list_only:
        for case in mgr.itercases():
            print(case.fname)
            for task in case.tasks:
                print('   %s' % task)
        return

    #--

    reporters = []
    if not mgr.config.quiet:
        reporters.append(atheist.ConsoleSummaryReporter(mgr.config))

    #--

    i = 0
    while 1:
        pb = ProgressBar(len(mgr),
                         width= int(mgr.config.screen_width),
                         label='Run ',
                         disable= mgr.config.verbosity or \
                             mgr.config.quiet or \
                             mgr.config.stdout or \
                             mgr.config.stderr)

        mgr.run(pb.inc)

        pb.clean()

        if mgr.config.until_failure and mgr.ALL():
            print "ALL OK, repeat until failure: %s: %s tasks" % (i, mgr.ntests)
            atheist.clean_generated()
            i += 1
            time.sleep(0.5)
        else:
            break

        if mgr.abort:
            sys.exit(1)

    for i in mgr.config.jabber:
        reporters.append(atheist.JabberSummaryReporter(i))
    for i in mgr.config.mail:
        reporters.append(atheist.MailSummaryReporter(i))

    for n in reporters:
        n.update(mgr)

    #--

    if mgr.ntests:
        print("Total: %s" % mgr.str_stats())

    return mgr.fail


def abort_handler(sign, frame):
    print()
    Log.warning("C-c pressed!")
    Manager().abort = True


if __name__ == '__main__':

    signal.signal(signal.SIGPIPE, signal.SIG_DFL)
    signal.signal(signal.SIGINT, abort_handler)
    signal.signal(signal.SIGTERM, abort_handler)

    sys.exit(main(sys.argv))


