# -*- mode: python; coding: utf-8 -*-
""" Composite tasks and conditions """

import types

import atheist
from atheist.const import *




class CompositeCondition(atheist.ConditionDecorator):
    def __init__(self, oper, *conds):
        assert callable(oper)
        self.oper = oper
        atheist.ConditionDecorator.__init__(self, *conds)

    def run(self):
        return self.oper([c.run() for c in self.conds])

class Or(CompositeCondition):
    def __init__(self, *conds):
        CompositeCondition.__init__(self, any, *conds)
