# -*- mode: python; coding: utf-8 -*-

import atheist


class TaskFinished(atheist.Condition):
    """Check if some Task has been executed or not (pending of execution)"""

    def __init__(self, task):
        assert isinstance(task, atheist.Task)
        self.the_task = task
        atheist.Condition.__init__(self)

    def run(self):
        return self.the_task.result in (atheist.FAIL, atheist.OK)


class TaskRunning(atheist.Condition):
    """Check whether some Task is running or not"""

    def __init__(self, task):
        assert isinstance(task, atheist.Task)
        self.the_task = task
        atheist.Condition.__init__(self)

    def run(self):
        return ((self.the_task.ps is not None) and
                (self.the_task.ps.poll() is None))

    def basic_info(self):
        return "'%s'" % self.the_task.name


class TaskTerminator(atheist.Task):
    """A special task to kill and ensure the termination of other tasks."""

    def __init__(self, tasks, **kargs):
        if isinstance(tasks, atheist.Task):
            tasks = [tasks]

        self.tasks = atheist.TypedList(atheist.Task)
        for t in tasks:
            self.tasks += t

        atheist.Task.__init__(self, **kargs)

        # FIXME: aún no está fijado el indx
        self.desc = "Terminates %s" % \
            ', '.join(['T'+str(x.indx) for x in self.tasks])

        for t in self.tasks:
            self.post += atheist.Poll(atheist.Not(TaskRunning(t)))

    def exec_task(self):
        for t in self.tasks:
            self.log.debug("terminates %s sending signal %s" % \
                               (t.name, t.signal))
            t.kill()

    def str_param(self):
        return [x.name for x in self.tasks]

