#!/usr/bin/python2.5
# -*- mode: python; coding: utf-8 -*-

# atheist
#
# Copyright (C) 2009,2010 David Villa Alises
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os, sys
import signal
import time

import atheist
from atheist.manager import Manager
from atheist.gvar import Log

mng = None

def main(argv):
    global mng

    if not os.path.exists(atheist.const.ATHEIST_TMP):
        os.mkdir(atheist.const.ATHEIST_TMP)

    mng = Manager(argv[1:])

    if not mng.args and not mng.cfg.inline:
        mng.parser.print_help()
        sys.exit(1)

    if mng.cfg.clean_only:
        atheist.remove_generated()
        return

    mng.reload()
    if len(mng) == 0:
        Log.warning("No testfiles found.")
        return

    if mng.cfg.describe:
        for t in mng.itertasks():
            print t.describe()
        return

    if mng.cfg.list_only:
        for case in mng.itercases():
            print(case.fname)
            for task in case.tasks:
                print('   %s' % task)
        return

    runner = mng.RunnerClass(mng)
    runner.run()
    runner.summary()

    return mng.fail


def abort_handler(sign, frame):
    print
    Log.warning("C-c pressed!")
    mng.abort()


if __name__ == '__main__':

    signal.signal(signal.SIGPIPE, signal.SIG_DFL)
    signal.signal(signal.SIGINT, abort_handler)
    signal.signal(signal.SIGTERM, abort_handler)

    sys.exit(main(sys.argv))
