# -*- mode:python; coding:utf-8 -*-
from pyarco.Logging import JabberHandler
from pyarco.UI import cout_config

import atheist
from atheist.gvar import Log

class JabberReporter(atheist.FailReporter, atheist.Plugin):
    def __init__(self, mng, account):
        handler = JabberHandler((mng.cfg['jabber.user'],
                                 mng.cfg['jabber.pass']),
                                account, Log)

        atheist.FailReporter.__init__(self, mng, 'jabber://'+account, handler)

    @classmethod
    def add_options(cls, parser):
        parser.add_option('--notify-jabber', dest='jabber', action='append', default=[],
                          help='notify failed tasks to the given jabber account')

    @classmethod
    def config(cls, mng):
        for account in mng.cfg.jabber:
            mng.reporters.append(JabberReporter(mng, account))
