# -*- mode:python; coding:utf-8 -*-
import time
import asyncore

import pyinotify as inotify

import atheist
from atheist.utils import compath
from atheist.gvar import Log

class NotifyRunner(atheist.Runner, atheist.Plugin):
    '''Re-run when a monitor file changes'''

    path = None
    watch_tests = False

    def __init__(self, mng):
        self.mng = mng
        atheist.Runner.__init__(self, mng)
        self.tinit = time.time()

    @classmethod
    def add_options(cls, parser):
        parser.add_option("--watch-tests", action='store_true',
                          help='Automatically re-run tests when they change')

        parser.add_option("--watch-dir",
                          help='Automatically re-run tests when specified directory content changes')

    @classmethod
    def config(cls, mng):
        if mng.cfg.watch_tests:
            cls.watch_tests = True
            mng.RunnerClass = cls

        if mng.cfg.watch_dir:
            cls.path = mng.cfg.watch_dir
            mng.RunnerClass = cls

    def do_run(self):
        atheist.Runner.run(self)
        self.summary()
        time.sleep(0.5)

    def run(self):
        class EventHandler(inotify.ProcessEvent):
            def __init__(self, runner):
                self.runner = runner

            def process_IN_MODIFY(self, event):
                Log.info("Modifed: %s" % compath(event.pathname))
                self.runner.do_run()

            def process_IN_CREATE(self, event):
                Log.info("Created: %s" % compath(event.pathname))

                self.runner.mng.reload()
                self.runner.do_run()

        def stop():
            Log.info('stopping notifier')
            self.notifier.stop()
            self.notifier.stop()


        self.do_run()

        wm = inotify.WatchManager()

        if self.watch_tests:
            print "Waiting for changes in test files"
            for case in self.mng.itercases():
                wm.add_watch(case.fname, inotify.IN_MODIFY)

        if self.path:
            print "Waiting for changes in '%s'" % self.path
            wm.add_watch(self.path, inotify.IN_MODIFY | inotify.IN_CREATE, rec=True, do_glob=True)

        handler = EventHandler(self)
        self.notifier = handler.notifier = inotify.Notifier(wm, handler, timeout=1000)

        self.mng.abort_observers.append(stop)
        try:
            self.notifier.loop()
            return
        except KeyError:
            pass
