# -*- mode:python; coding:utf-8 -*-
import time

import atheist

class UntilFailRunner(atheist.Runner, atheist.Plugin):
    def __init__(self, mng):
        atheist.Runner.__init__(self, mng)
        self.tinit = time.time()

    @classmethod
    def add_options(cls, parser):
        parser.add_option('-u', '--until-fail', action='store_true',
                          help='Repeat tests until something fails')

    @classmethod
    def config(cls, mng):
        if mng.cfg.until_fail:
            if mng.cfg.keep_going:
                mng.parser.error("-u/--until-fail and -k/--keep-going are incompatible options")

            mng.RunnerClass = cls

    def run(self):
        i = 1
        while 1:
            atheist.Runner.run(self)
            if self.mng.ALL():
                minutes = (time.time() - self.tinit) / 60
                print "ALL OK, repeat until failure: %s x %s tasks in %.1f minutes" % (i, self.mng.ntasks, minutes)
#                atheist.remove_generated()
                i += 1
                time.sleep(0.5)

            if self.mng.aborted:
                break

    def summary(self):
        atheist.Runner.summary(self)

        minutes = (time.time() - self.tinit) / 60
        print('%s: Ran %s tasks in %.1f minutes, %.1f tasks/minute' % (
                time.asctime(), self.mng.ntasks, minutes, self.mng.ntests/minutes))
