# -*- mode: python; coding: utf-8 -*-

from __future__ import with_statement
import os, sys
import time
import string
import subprocess
import types
import logging
import threading
import ConfigParser
import logging

from atheist.const import *

import atheist.log
from atheist.gvar import Log


def count(n, unit):
    """
    >>> count(3, 'tick')
    '3 ticks'
    >>> count(1, 'dog')
    '1 dog'
    """
    return "%s %s%s" % (n, unit, 's' if n>1 else '')

def run_cmd(cmd):
    devnull = open('/dev/null', 'w')
    ps = subprocess.Popen(cmd, shell=True,
                          stdout=subprocess.PIPE, stderr=devnull)
    output = ps.communicate()[0]
    devnull.close()
    ps.stdout.close()
    return ps.returncode, output


def remove_dups(val):
    """
    >>> remove_dups([1,2,3,1,2])
    [1, 2, 3]
    >>> remove_dups([1,1,2,1,2,1])
    [1, 2]
    """
    retval = []
    for x in val:
        if x not in retval: retval.append(x)
    return retval


# from python2.6
def relpath(path, start=os.curdir):
    """Return a relative version of a path"""

    if not path:
        raise ValueError("no path specified")

    start_list = os.path.abspath(start).split(os.path.sep)
    path_list = os.path.abspath(path).split(os.path.sep)

    # Work out how much of the filepath is shared by start and path.
    i = len(os.path.commonprefix([start_list, path_list]))

    rel_list = [os.pardir] * (len(start_list)-i) + path_list[i:]
    if not rel_list:
        return os.curdir
    return os.path.join(*rel_list)


def compath(path=None):
    if path is None:
        path = compath.root

    try:
        retval = relpath(path, compath.root)
    except ValueError:
        return path

    if not retval[0] in [os.sep, os.curdir]:
        retval = os.curdir + os.sep + retval

    if len(retval) > len(path): return path
    return retval


def print_exc(exc, logger=logging):
    for line in exc.split('\n'):
        if line.strip(): logger.error('| ' + line)


class IniParser(ConfigParser.ConfigParser):

    def __init__(self, fname):
        self.fname = fname
        ConfigParser.ConfigParser.__init__(self)
        self.read(fname)


    def get_item(self, path, default=None):
        try:
            if '.' in path:
                sect, name = path.split('.')
            else:
                sect = 'DEFAULT'
                name = key

            retval = self.get(sect, name)

            if not retval.strip():
                Log.warning("File '%s': key '%s' contains nothing" % \
                                 (self.fname, path))

            return retval

        except ConfigParser.NoOptionError, e:
            if default is None: raise
            return default

    def get_sec(self, sec_name):
        try:
            return Record(**dict(self.items(sec_name)))
        except ConfigParser.NoSectionError, e:
            Log.critical("A '%s' section is required in your '%s'." % \
                              (sec_name, self.fname))
            sys.exit(1)

    def __getitem__(self, path):
        try:
            return self.get_item(path)
        except  (ConfigParser.NoOptionError, ConfigParser.NoSectionError), e:
            Log.critical("In file '%s'. %s" % (self.fname, e))
            sys.exit()


def tree_draw(container, cb, conn='', args=[]):
    '''utility for arbitrary tree representation'''

    lon = len(container)
    for i,item in enumerate(container):
        brother = u'├─'
        parent  = u'│  '

        if lon == i+1:
            brother = u'└─'
            parent  = '   '

        cb(item,
           conn + parent,
           conn + brother, *args)
