// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright (C) 2000 Stefanus Du Toit

#ifndef ATLAS_OBJECTS_DECODER_H
#define ATLAS_OBJECTS_DECODER_H

#include <Atlas/Message/DecoderBase.h>

namespace Atlas { namespace Objects {

class Root;

namespace Entity {

class Account;
class Admin;
class AdminEntity;
class Game;
class Player;
class RootEntity;

}

namespace Operation {

class Action;
class Appearance;
class Combine;
class Communicate;
class Create;
class Delete;
class Disappearance;
class Divide;
class Error;
class Feel;
class Get;
class Imaginary;
class Info;
class Listen;
class Login;
class Logout;
class Look;
class Move;
class Perceive;
class Perception;
class RootOperation;
class Set;
class Sight;
class Smell;
class Sniff;
class Sound;
class Talk;
class Touch;

}

/** Objects hierarchy decoder
 *
 * This decoder can be bound to a codec, will assemble incoming messages,
 * check their type, convert them into the appropriate instance in the
 * Objects hierarchy and call the relevant member functions, which
 * subclasses can conveniently override to pick up the object.
 *
 * @see Atlas::Objects::Encoder
 * @author Stefanus Du Toit <sdt@gmx.net>
 */
class Decoder : public Atlas::Message::DecoderBase
{
public:
    /// Default destructor.
    virtual ~Decoder();

protected:
    /// Overridden by Objects::Decoder to retrieve the object.
    virtual void objectArrived(const Atlas::Message::Element&);

    /// An unknown object has arrived.
    virtual void unknownObjectArrived(const Atlas::Message::Element&) { }

    /// A Root object has arrived.
    virtual void objectArrived(const Root&) { }

    virtual void objectArrived(const Entity::Account&) { }
    virtual void objectArrived(const Entity::Admin&) { }
    virtual void objectArrived(const Entity::AdminEntity&) { }
    virtual void objectArrived(const Entity::Game&) { }
    virtual void objectArrived(const Entity::Player&) { }
    virtual void objectArrived(const Entity::RootEntity&) { }

    virtual void objectArrived(const Operation::Action&) { }
    virtual void objectArrived(const Operation::Appearance&) { }
    virtual void objectArrived(const Operation::Combine&) { }
    virtual void objectArrived(const Operation::Communicate&) { }
    virtual void objectArrived(const Operation::Create&) { }
    virtual void objectArrived(const Operation::Delete&) { }
    virtual void objectArrived(const Operation::Disappearance&) { }
    virtual void objectArrived(const Operation::Divide&) { }
    virtual void objectArrived(const Operation::Error&) { }
    virtual void objectArrived(const Operation::Feel&) { }
    virtual void objectArrived(const Operation::Get&) { }
    virtual void objectArrived(const Operation::Imaginary&) { }
    virtual void objectArrived(const Operation::Info&) { }
    virtual void objectArrived(const Operation::Listen&) { }
    virtual void objectArrived(const Operation::Login&) { }
    virtual void objectArrived(const Operation::Logout&) { }
    virtual void objectArrived(const Operation::Look&) { }
    virtual void objectArrived(const Operation::Move&) { }
    virtual void objectArrived(const Operation::Perceive&) { }
    virtual void objectArrived(const Operation::Perception&) { }
    virtual void objectArrived(const Operation::RootOperation&) { }
    virtual void objectArrived(const Operation::Set&) { }
    virtual void objectArrived(const Operation::Sight&) { }
    virtual void objectArrived(const Operation::Smell&) { }
    virtual void objectArrived(const Operation::Sniff&) { }
    virtual void objectArrived(const Operation::Sound&) { }
    virtual void objectArrived(const Operation::Talk&) { }
    virtual void objectArrived(const Operation::Touch&) { }
    
};

} } // namespace Atlas::Objects
#endif
