/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include "vnet.h"
extern WINDOW *conf_win;
WINDOW *SSID_win;
WINDOW *Channel_win;
WINDOW *Power_win;
WINDOW *Op_win;
WINDOW *Rate_win;
WINDOW *Roaming_win;
WINDOW *Preamble_win;
WINDOW *Frag_win;
WINDOW *Mgmt_win;
WINDOW *Rts_win;
WINDOW *wep_win;
WINDOW *enc_wep_win;
WINDOW *wep_auth_win;
WINDOW *wep_value_win;
WINDOW *wep_mode_win;
WINDOW *error_win;

int wep_reverse ;
int wep_epilogh = 0;


char *wep_choices[] = {
             "Select Encryption Level",
             "Set    Wep Key Value",
             "Set    Wep Mode",
             "Set    Authentication type",
             "Exit   Menu",
                  };
int wep_config_choices = sizeof(wep_choices) / sizeof(char *);


int Set_ESSID(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd)
{
	WINDOW *error10_win;
	int i, temp, n_bytes;
	int c, k;
	char str[pAppInfo->SSIDlength];
	struct iwreq wrq;
	char Get_Arg[BUFSIZ];

	error10_win = newwin(6, 60,15, 4);	
	box(error10_win, 0, 0);
	SSID_win = create_inputwin(6, 60,15, 4);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	//box(SSID_win, 0,0);
	wattron(SSID_win, A_BOLD);
	wattron(SSID_win, COLOR_PAIR(7));
	mvwprintw(SSID_win, 1, 10, "Press F1 to Exit");
	wattroff(SSID_win, COLOR_PAIR(7));
	wattroff(SSID_win, A_BOLD);
	mvwprintw(SSID_win, 2, 1, "Desired Essid :");
	wrefresh(SSID_win);
	temp = (pAppInfo->SSIDlength);
	memset(Get_Arg,'\0', 32);
	k =0;
        keypad(SSID_win, TRUE);
        while (1)
        {
                echo();
                        c = mvwgetch(SSID_win, 2, 16 + k);
                switch(c)
                {
                        case KEY_F(1):
                                        noecho();
					wclear(SSID_win);
					destroy_win(SSID_win);
                                        break;
                        case KEY_BACKSPACE:
                                        noecho();
                                        if( k > 0 )
                                        {
                                                k--;
                                        }
                                        mvwdelch(SSID_win, 2, 16 + k);
                                        wrefresh(SSID_win);
                                        Get_Arg[k]= '\0';
                                        break;
                        case 10:
                                        noecho();
                                        break;
                        default:
                                        if ( k < 31)
                                        {
                                        Get_Arg[k] = c;
                                        k++;
   					 }else{
                                                noecho();
                                        }

                                        break;
                }
                if ( c == 10)
                {
                                Get_Arg[k] = '\0';
                                wclear(SSID_win);
                                destroy_win(SSID_win);
                                redrawwin(conf_win);
                                break;
                }
                if ( c == KEY_F(1))
                {
				strcpy(Get_Arg, pAppInfo->SSID);
//	                        memset(Get_Arg,'\0', 33- strlen(pAppInfo->SSID));
                                wclear(SSID_win);
                                destroy_win(SSID_win);
                                redrawwin(conf_win);
                        //        wrefresh(conf_win);
                                break;
                }
        }

		pAppInfo->SSIDlength = (strlen(Get_Arg));
		noecho();
		strcpy(pAppInfo->SSID, Get_Arg);
    		strcpy(wrq.ifr_name,cname);
    		wrq.u.data.pointer = (caddr_t)pAppInfo;		// Mem address of passing down structure
		wrq.u.data.length = sizeof(DEVICE_CONFIGURATION);	// size of structure
  		wrq.u.data.flags = SET_SUPPORT_INFO;		// private io control
		if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
			wattron(error10_win, A_BOLD);
			wattron(error10_win, COLOR_PAIR(7));
			mvwprintw(error10_win, 2, 22, "Setting ESSID failed !!!");
			mvwprintw(error10_win, 4, 23, "Press Any Key");
			wattroff(error10_win, COLOR_PAIR(7));
			wattroff(error10_win, A_BOLD);
			wrefresh(error10_win);
			return -EIO;
		}else{
			wclear(SSID_win);
			destroy_win(SSID_win);
                                redrawwin(conf_win);
		}	
//	while(c = getch()){
//		if(c == KEY_F(1))
//		{
//			wclear(SSID_win);
//			destroy_win(SSID_win);
//			break;
//		}
//	}
	return 0;
}


int Set_Channel(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd)
{
	struct iwreq 	wrq;
	int i, c, k, d, value, hvalid, lvalid;
	int get_ch[2];
	
	error_win = newwin(6, 60, 15, 4);
	box(error_win, 0, 0);

	Channel_win = create_inputwin(6, 60,15, 4);	
			if (pAppInfo->OperatingMode==1){
				init_pair(7, COLOR_RED, COLOR_BLACK);
				wattron(error_win, A_BOLD);
				wattron(error_win, COLOR_PAIR(7));
				mvwprintw(error_win, 2, 4, "Channel cannot change while in InfraStructure Mode!!!");
				mvwprintw(error_win, 4, 21, "Press Any Key");
				wattroff(error_win, COLOR_PAIR(7));
				wrefresh(error_win);				
				return -EINVAL;
			}
			init_pair(7, COLOR_RED, COLOR_BLACK);
			wattron(Channel_win, A_BOLD);
			wattron(Channel_win, COLOR_PAIR(7));
			mvwprintw(Channel_win, 1, 1, "Cancel or Exit-> Press F1");
			wattroff(Channel_win, COLOR_PAIR(7));
			mvwprintw(Channel_win, 2, 1, "Setting Channel. Range 1 - 14. Choice : ");
				wrefresh(Channel_win);				
		k =0;
                keypad(Channel_win, TRUE);
        	while (1)
        	{
			echo();
			if(k ==2){
				noecho();
			}
                        c = mvwgetch(Channel_win, 2, 41 + k);
                	switch(c)
                	{
                        	case      KEY_F(1):
                                	  	      noecho();
						      wclear(Channel_win);
						      destroy_win(Channel_win);
                                  		      break;
                        	case KEY_BACKSPACE:
				                       noecho();
			                              if( k > 0 )
                        	                      {
                                                	k--;
                                        		}
                                        		mvwdelch(Channel_win, 2, 41 + k);
                                        		wrefresh(Channel_win);
                                        		break;
                        	case 		10:
                                        		noecho();
                                        		break;
                        	default		  :
							 if ( k < 2){
							       	get_ch[k]= c - '0';
								refresh();
								k++;
                                	       		}else{
								noecho();
							}	
                                        		break;
                	}
                if ( c == KEY_F(1))
                {
				value = pAppInfo->Channel;
                                wclear(Channel_win);
                                destroy_win(Channel_win);
                                redrawwin(conf_win);
                                break;
                }
                if ( c == 10){
		refresh();
			switch(k)
			{
				case 1 :
					value = get_ch[0];
					break;
				case 2 :
					value = 10 * get_ch[0] + get_ch[1];
					break;

				default :
					break;
			}
                                wclear(Channel_win);
                                destroy_win(Channel_win);
                                redrawwin(conf_win);
				break;
		}
        }

                if(!(pAppInfo->InternationalRoaming)){
                    switch(pAppInfo->RegDomain)
                    {
                    case 0x10:
                        hvalid = 12; 
                        lvalid = 1; 
                        break;
                    case 0x20:     
                        hvalid = 12; 
                        lvalid = 11; 
                        break;
                    case 0x30: 
                        hvalid = 14; 
                        lvalid = 1; 
                        break;
                    case 0x31:
                        hvalid = 12; 
                        lvalid = 10; 
                        break;
                    case 0x32:
                        hvalid = 14; 
                        lvalid = 10; 
                        break;
                    case 0x40:
                        hvalid = 15; 
                        lvalid = 14; 
                        break;
                    case 0x41:
                        hvalid = 14; 
                        lvalid = 1; 
                        break;
                    case 0x50:
                        hvalid = 10; 
                        lvalid = 3; 
                        break;
                    default:
                        hvalid = 15; 
                        lvalid = 1; 
                        break;
                    }
                }else {
                        lvalid = 1;
                        hvalid = 14;
                }
	 	if ((value<lvalid)||(value>hvalid)){
				wattron(error_win,A_BOLD); 
				wattron(error_win, COLOR_PAIR(1));
        	                mvwprintw(error_win, 2, 22, "Invalid value!!!");
        	                mvwprintw(error_win, 4, 23, "Press any Key");
				wattroff(error_win, COLOR_PAIR(1));
				wattroff(error_win,A_BOLD); 
                	        wrefresh(error_win);
				return -EINVAL;
                }


		pAppInfo->Channel=value;
		wrefresh(Channel_win);
		noecho();
		strcpy(wrq.ifr_name,cname);
		wrq.u.data.pointer = (caddr_t)pAppInfo;
		wrq.u.data.length  = sizeof(DEVICE_CONFIGURATION);
		wrq.u.data.flags   = SET_SUPPORT_INFO;
		if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
				wattron(error_win,A_BOLD); 
				wattron(error_win, COLOR_PAIR(1));
   			mvwprintw(Channel_win, 4, 5, "Setting Channel failed!!!");
				wattroff(error_win, COLOR_PAIR(1));
				wattroff(error_win,A_BOLD); 
			wrefresh(Channel_win);
		//	while(c = getch()){
		//		if(c == KEY_F(1))
		//		{
		//			wclear(Channel_win);
		//			destroy_win(Channel_win);
		//			break;
		//		}
		//	}
		return -EIO;
		}
		else{
			wclear(Channel_win);
			destroy_win(Channel_win);
                                redrawwin(conf_win);
		}
	wattroff(Channel_win, A_BOLD);
	return 0;
}   			

int Set_InternationalRoaming(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd)
{
	WINDOW *error21_win;
	struct iwreq	wrq;
	int c, k, value;
	int get_roam[1];
	
	error21_win = newwin(6, 60, 15, 4);
	box(error21_win, 0, 0);
	
	Roaming_win = create_inputwin(6, 60,15, 4);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	wattron(Roaming_win, A_BOLD);
	wattron(Roaming_win, COLOR_PAIR(7));
	mvwprintw(Roaming_win, 1, 30, "Cancel or Exit-> Press F1");
	wattroff(Roaming_win, COLOR_PAIR(7));
	mvwprintw(Roaming_win, 1,1, "International Roaming State.");
	mvwprintw(Roaming_win, 2,1, "(0) Disable, (1) Enable.");
	mvwprintw(Roaming_win,3, 1, "Select State : ");
	wrefresh(Roaming_win);
		k =0;
                keypad(Roaming_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==1){
                                noecho();
                        }
                        c = mvwgetch(Roaming_win, 3, 16 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      wclear(Roaming_win);
                                                      destroy_win(Roaming_win);
                                                      break;
                                case KEY_BACKSPACE:
                                                   noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(Roaming_win, 3, 16 + k);
                                                        wrefresh(Roaming_win);
                                                        break;
                                case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 1){
                                                                get_roam[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == KEY_F(1))
                {
                                value = pAppInfo->InternationalRoaming;
                                wclear(Roaming_win);
                                destroy_win(Roaming_win);
                                redrawwin(conf_win);
                                break;
                }
         	if ( c == 10){
				value = get_roam[0];
                                wclear(Roaming_win);
                                destroy_win(Roaming_win);
                                redrawwin(conf_win);
                                break;
                }
        }

	if ((value<0)||(value>1)){
                                wattron(error21_win,A_BOLD);
                                wattron(error21_win, COLOR_PAIR(1));
                                mvwprintw(error21_win, 2, 22, "Invalid value!!!");
                                mvwprintw(error21_win, 4, 23, "Press any Key");
                                wattroff(error21_win, COLOR_PAIR(1));
                                wattroff(error21_win,A_BOLD);
                                wrefresh(error21_win);
		return -EINVAL;
	}
	pAppInfo->InternationalRoaming=value;		
	strcpy(wrq.ifr_name,cname);
   	wrq.u.data.pointer = (caddr_t)pAppInfo;
   	wrq.u.data.length  = sizeof(DEVICE_CONFIGURATION);
   	wrq.u.data.flags   = SET_SUPPORT_INFO;
   	
   	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
                                wattron(error21_win,A_BOLD);
                                wattron(error21_win, COLOR_PAIR(1));
		mvwprintw(error21_win, 2,10, "Setting International Roaming failed!!!");
                                mvwprintw(error21_win, 4, 23, "Press any Key");
                                wattroff(error21_win, COLOR_PAIR(1));
                                wattroff(error21_win,A_BOLD);
		wrefresh(error21_win);
   		return -EIO;
   	}
	wattroff(Roaming_win, A_BOLD);
   	return 0;
}   			

int Set_Radio(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd)
{
	WINDOW *error11_win;
	struct iwreq	wrq;
	int c, k, value;
	int get_roam[1];
	
	error11_win = newwin(6, 60, 15, 4);
	box(error11_win, 0, 0);
	
	Power_win = create_inputwin(6, 60,15, 4);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	wattron(Power_win, A_BOLD);
	wattron(Power_win, COLOR_PAIR(7));
	mvwprintw(Power_win, 1, 30, "Cancel or Exit-> Press F1");
	wattroff(Power_win, COLOR_PAIR(7));
	mvwprintw(Power_win, 1,1, "Radio State.");
	mvwprintw(Power_win, 2,1, "(0) Off, (1) On.");
	mvwprintw(Power_win,3, 1, "Select State : ");
	wrefresh(Power_win);
		k =0;
                keypad(Power_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==1){
                                noecho();
                        }
                        c = mvwgetch(Power_win, 3, 16 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      wclear(Power_win);
                                                      destroy_win(Power_win);
                                                      break;
                                case KEY_BACKSPACE:
                                                   noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(Power_win, 3, 16 + k);
                                                        wrefresh(Power_win);
                                                        break;
                                case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 1){
                                                                get_roam[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == KEY_F(1))
                {
                                value = pAppInfo->RadioIsOn;
                                wclear(Power_win);
                                destroy_win(Power_win);
                                redrawwin(conf_win);
                                break;
                }
         	if ( c == 10){
				value = get_roam[0];
                                wclear(Power_win);
                                destroy_win(Power_win);
                                redrawwin(conf_win);
                                break;
                }
        }

	if ((value<0)||(value>1)){
                                wattron(error11_win,A_BOLD);
                                wattron(error11_win, COLOR_PAIR(1));
                                mvwprintw(error11_win, 2, 22, "Invalid value!!!");
                                mvwprintw(error11_win, 4, 23, "Press any Key");
                                wattroff(error11_win, COLOR_PAIR(1));
                                wattroff(error11_win,A_BOLD);
                                wrefresh(error11_win);
		return -EINVAL;
	}
	pAppInfo->RadioIsOn=value;		
	strcpy(wrq.ifr_name,cname);
   	wrq.u.data.pointer = (caddr_t)pAppInfo;
   	wrq.u.data.length  = sizeof(DEVICE_CONFIGURATION);
   	wrq.u.data.flags   = SET_SUPPORT_INFO;
   	
   	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
                                wattron(error11_win,A_BOLD);
                                wattron(error11_win, COLOR_PAIR(1));
		mvwprintw(error11_win, 2,10, "Setting Radio failed!!!");
                                mvwprintw(error11_win, 4, 23, "Press any Key");
                                wattroff(error11_win, COLOR_PAIR(1));
                                wattroff(error11_win,A_BOLD);
		wrefresh(error11_win);
   		return -EIO;
   	}
	wattroff(Power_win, A_BOLD);
   	return 0;
}   			

int Set_PowerMgmtMode(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd)
{
	WINDOW *error41_win;
	struct iwreq	wrq;
	int c, k, value;
	int get_roam[1];
	
	error41_win = newwin(6, 60, 15, 4);
	box(error41_win, 0, 0);
	
	Mgmt_win = create_inputwin(6, 60,15, 4);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	wattron(Mgmt_win, A_BOLD);
	wattron(Mgmt_win, COLOR_PAIR(7));
	mvwprintw(Mgmt_win, 1, 30, "Cancel or Exit-> Press F1");
	wattroff(Mgmt_win, COLOR_PAIR(7));
	mvwprintw(Mgmt_win, 1,1, "PowerMgmt Mode State.");
	mvwprintw(Mgmt_win, 2,1, "(0) Active, (1) Power Save.");
	mvwprintw(Mgmt_win,3, 1, "Select State : ");
	wrefresh(Mgmt_win);
		k =0;
                keypad(Mgmt_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==1){
                                noecho();
                        }
                        c = mvwgetch(Mgmt_win, 3, 16 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      wclear(Mgmt_win);
                                                      destroy_win(Mgmt_win);
                                                      break;
                                case KEY_BACKSPACE:
                                                   noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(Mgmt_win, 3, 16 + k);
                                                        wrefresh(Mgmt_win);
                                                        break;
                                case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 1){
                                                                get_roam[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == KEY_F(1))
                {
                                value = pAppInfo->PowerMgmtMode;
                                wclear(Mgmt_win);
                                destroy_win(Mgmt_win);
                                redrawwin(conf_win);
                                break;
                }
         	if ( c == 10){
				value = get_roam[0];
                                wclear(Mgmt_win);
                                destroy_win(Mgmt_win);
                                redrawwin(conf_win);
                                break;
                }
        }

	if ((value<0)||(value>1)){
                                wattron(error41_win,A_BOLD);
                                wattron(error41_win, COLOR_PAIR(1));
                                mvwprintw(error41_win, 2, 22, "Invalid value!!!");
                                mvwprintw(error41_win, 4, 23, "Press any Key");
                                wattroff(error41_win, COLOR_PAIR(1));
                                wattroff(error41_win,A_BOLD);
                                wrefresh(error41_win);
		return -EINVAL;
	}
	pAppInfo->PowerMgmtMode=value;		
	strcpy(wrq.ifr_name,cname);
   	wrq.u.data.pointer = (caddr_t)pAppInfo;
   	wrq.u.data.length  = sizeof(DEVICE_CONFIGURATION);
   	wrq.u.data.flags   = SET_SUPPORT_INFO;
   	
   	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
                                wattron(error41_win,A_BOLD);
                                wattron(error41_win, COLOR_PAIR(1));
		mvwprintw(error41_win, 2,10, "Setting Power Mgmt failed!!!");
                                mvwprintw(error41_win, 4, 23, "Press any Key");
                                wattroff(error41_win, COLOR_PAIR(1));
                                wattroff(error41_win,A_BOLD);
		wrefresh(error41_win);
   		return -EIO;
   	}
	wattroff(Mgmt_win, A_BOLD);
   	return 0;
}   			

int Set_TxRate(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd)
{  
	WINDOW * error1_win;
	struct iwreq	wrq;
	int c, k, value;
	int get_rate[1];
	
	error1_win = newwin(6, 60, 15, 4);
	box(error1_win, 0, 0);
	Rate_win = create_inputwin(6, 60,15, 4);	
	init_pair(11, COLOR_RED, COLOR_BLACK);
	wattron(Rate_win, A_BOLD);
	wattron(Rate_win, COLOR_PAIR(11));
	mvwprintw(Rate_win, 1, 38, "Cancel-Exit -> F1");
	wattroff(Rate_win, COLOR_PAIR(11));
	wrefresh(Rate_win);
	mvwprintw(Rate_win, 1,1, "Setting Transmit Rate. 0 for 1Mbps,");
	mvwprintw(Rate_win, 2,1, "1 for 2Mbps, 2 for 5.5Mbps, 3 for 11Mbps, 4 Automatic.");
	mvwprintw(Rate_win,3, 1, "Select Rate : ");
	wrefresh(Rate_win);
	k =0;
                keypad(Rate_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==1){
                                noecho();
                        }
                        c = mvwgetch(Rate_win, 3, 15 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      break;
                                case KEY_BACKSPACE:
                                                       noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(Rate_win, 3, 15 + k);
                                                        wrefresh(Rate_win);
                                                        break;
				 case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 1){
                                                                get_rate[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == 10){
                                value = get_rate[0];
                                wclear(Rate_win);
                                destroy_win(Rate_win);
                                redrawwin(conf_win);
		                 break;
                }
                if ( c == KEY_F(1))
                {
   				value = pAppInfo->TxRate;
                                wclear(Rate_win);
                                destroy_win(Rate_win);
                                redrawwin(conf_win);
                                break;
                }
        }
                if ((value<0)||(value>4)){
                                wattron(error1_win,A_BOLD);
                                wattron(error1_win, COLOR_PAIR(1));
                                mvwprintw(error1_win, 2, 22, "Invalid value!!!");
                                mvwprintw(error1_win, 4, 23, "Press any Key");
                                wattroff(error1_win, COLOR_PAIR(1));
                                wattroff(error1_win,A_BOLD);
                                wrefresh(error1_win);
                                return -EINVAL;
                }
   	pAppInfo->TxRate=value;
   	strcpy(wrq.ifr_name,cname);
   	wrq.u.data.pointer = (caddr_t)pAppInfo;
   	wrq.u.data.length = sizeof(DEVICE_CONFIGURATION);
   	wrq.u.data.flags = SET_SUPPORT_INFO;
   	
   	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
                                wattron(error1_win,A_BOLD);
                                wattron(error1_win, COLOR_PAIR(1));
		mvwprintw(error1_win, 2,1, "Setting Transmit Rate failed!!!");
                                mvwprintw(error1_win, 4, 23, "Press any Key");
                                wattroff(error1_win, COLOR_PAIR(1));
                                wattroff(error1_win,A_BOLD);
		wrefresh(error1_win);
//	while(c = getch()){
//		if(c == KEY_F(1))
//		{
//			wclear(Rate_win);
//			destroy_win(Rate_win);
//			break;
//		}
//	}
   		return -EIO;
   	}else{
		wclear(Rate_win);
		destroy_win(Rate_win);
                                redrawwin(conf_win);
	}
	//while(c = getch()){
	//	if(c == KEY_F(1))
	//	{
	//		wclear(Rate_win);
	//		destroy_win(Rate_win);
	//		break;
	//	}
	//}
	wattroff(SSID_win, A_BOLD);
   	return 0;
}

int Set_OpMode(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd)
{
	WINDOW *error2_win;
	struct iwreq 	wrq;
	int c, k, value;
	int get_op[1];
	
	error2_win = newwin(6, 60, 15, 4);
	box(error2_win, 0, 0);
	Op_win = create_inputwin(6, 60,15, 4);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	wattron(Op_win, A_BOLD);
	wattron(Op_win, COLOR_PAIR(7));
	mvwprintw(Op_win, 1, 30, "Cancel or Exit-> Press F1");
	wattroff(Op_win, COLOR_PAIR(7));
	mvwprintw(Op_win, 1,1, "Setting Operating Mode.");
	mvwprintw(Op_win, 2,1, "(0) for Ad-Hoc, (1) for InfraStructure, (3) for AP_MODE.");
	mvwprintw(Op_win,3, 1, "Select Mode : ");
	wrefresh(Op_win);
	
	k =0;
                keypad(Op_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==1){
                                noecho();
                        }
                        c = mvwgetch(Op_win, 3, 15 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      break;
                                case KEY_BACKSPACE:
                                                       noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(Op_win, 3, 15 + k);
                                                        wrefresh(Op_win);
       	                                                break;
                                 case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 1){
                                                                get_op[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == 10){
                                value = get_op[0];
                                wclear(Op_win);
                                destroy_win(Op_win);
                                redrawwin(conf_win);
                                 break;
                }
                if ( c == KEY_F(1))
                {
   				value = pAppInfo->OperatingMode;
                                wclear(Op_win);
                                destroy_win(Op_win);
                                redrawwin(conf_win);
                                break;
                }
        }
	
	
   	if ((value<0)||(value>3))
   	{
	       wattron(error2_win,A_BOLD);
               wattron(error2_win, COLOR_PAIR(1));
               mvwprintw(error2_win, 2, 22, "Invalid value!!!");
               mvwprintw(error2_win, 4, 23, "Press any Key");
               wattroff(error2_win, COLOR_PAIR(1));
               wattroff(error2_win,A_BOLD);
               wrefresh(error2_win);
   	return -EINVAL;
   	}
   	pAppInfo->OperatingMode=value;
   	strcpy(wrq.ifr_name,cname);
   	wrq.u.data.pointer=(caddr_t)pAppInfo;
   	wrq.u.data.length=sizeof(DEVICE_CONFIGURATION);
   	wrq.u.data.flags= SET_SUPPORT_INFO;
   	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
	       wattron(error2_win,A_BOLD);
               wattron(error2_win, COLOR_PAIR(1));
		mvwprintw(error2_win, 2,1, "Setting Operating Mode failed!!!");
               mvwprintw(error2_win, 4, 23, "Press any Key");
               wattroff(error2_win, COLOR_PAIR(1));
               wattroff(error2_win,A_BOLD);
		wrefresh(error2_win);
//	while(c = getch()){
//		if(c == KEY_F(1))
//		{
//			wclear(Op_win);
//			destroy_win(Op_win);
//			break;
//		}
//	}
		return -EIO;
   	}else{
		wclear(Op_win);
		destroy_win(Op_win);		
                                redrawwin(conf_win);
	}
	//while(c = getch()){
//		if(c == KEY_F(1))
//		{
//			wclear(Op_win);
//			destroy_win(Op_win);
//			break;
//		}
//	}
   	return 0;
}

int Set_Preamble(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd)
{
	WINDOW *error3_win;
	struct iwreq	wrq;
	int c, k, value;
	int get_pr[1];
	
	error3_win = newwin(6, 60, 15, 4);
	box(error3_win, 0, 0);
	Preamble_win = create_inputwin(6, 60,15, 4);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	wattron(Preamble_win, A_BOLD);
	wattron(Preamble_win, COLOR_PAIR(7));
	mvwprintw(Preamble_win, 1, 30, "Cancel or Exit-> Press F1");
	wattroff(Preamble_win, COLOR_PAIR(7));
	mvwprintw(Preamble_win, 1,1, "Setting Preamble Type.");
	mvwprintw(Preamble_win, 2,1, "(0) for Long Type, (1) for Short Type.");
	mvwprintw(Preamble_win,3, 1, "Select Type : ");
	wrefresh(Preamble_win);
		k =0;
                keypad(Preamble_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==2){
                                noecho();
                        }
                        c = mvwgetch(Preamble_win, 3, 15 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      wclear(Preamble_win);
                                                      destroy_win(Preamble_win);
                                                      break;
                                case KEY_BACKSPACE:
                                                   noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(Preamble_win, 3, 15 + k);
                                                        wrefresh(Preamble_win);
                                                        break;
                                case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 2){
                                                                get_pr[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == KEY_F(1))
                {
                                value = pAppInfo->PreambleType;
                                wclear(Preamble_win);
                                destroy_win(Preamble_win);
                                redrawwin(conf_win);
                                break;
                }
         	if ( c == 10){
				value = get_pr[0];
                                wclear(Preamble_win);
                                destroy_win(Preamble_win);
                                redrawwin(conf_win);
                                break;
                }
        }

   	if ((value<0)||(value>1)){
	       wattron(error3_win,A_BOLD);
               wattron(error3_win, COLOR_PAIR(1));
		mvwprintw(error3_win, 2,22, "Invalid Value!!!");
		mvwprintw(error3_win, 4,23, "Press Any Key");
               wattroff(error3_win, COLOR_PAIR(1));
	       wattroff(error3_win,A_BOLD);
		wrefresh(error3_win);
   		return -EINVAL;
   	}
   	pAppInfo->PreambleType=value;
   	strcpy(wrq.ifr_name,cname);
   	wrq.u.data.pointer = (caddr_t)pAppInfo;
   	wrq.u.data.length = sizeof(DEVICE_CONFIGURATION);
   	wrq.u.data.flags = SET_SUPPORT_INFO;
   	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0) {
	       wattron(error3_win,A_BOLD);
               wattron(error3_win, COLOR_PAIR(1));
		mvwprintw(error3_win, 2,1, "Setting Preamble Type failed!!!");
		mvwprintw(error3_win, 4,23, "Press Any Key");
               wattroff(error3_win, COLOR_PAIR(1));
	       wattroff(error3_win,A_BOLD);
		wrefresh(error3_win);
   		return -EIO;
   	}else{
		wclear(Preamble_win);
		destroy_win(Preamble_win);
                                redrawwin(conf_win);
	}
	//while(c = getch()){
	//	if(c == KEY_F(1))
	//	{
	//		wclear(Preamble_win);
	//		destroy_win(Preamble_win);
	//		break;
	//	}
	//}
	wattroff(Preamble_win, A_BOLD);
   	return 0;
}

int Set_FragT(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd)
{
	WINDOW *error4_win;
	struct iwreq	wrq;
	int c, k, value;
	int get_frag[4];
	
	error4_win = newwin(6, 60, 15, 4);
	box(error4_win, 0, 0);
	Frag_win = create_inputwin(6, 60,15, 4);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	wattron(Frag_win, A_BOLD);
	wattron(Frag_win, COLOR_PAIR(7));
	mvwprintw(Frag_win, 1, 34, "Cancel or Exit-> Press F1");
	wattroff(Frag_win, COLOR_PAIR(7));
	mvwprintw(Frag_win, 1,1, "Setting Fragmentation Threshold.");
	mvwprintw(Frag_win, 2,1, "Valid Values : (256 -2346)");
	mvwprintw(Frag_win,3, 1, "Select Type : ");
	wrefresh(Frag_win);
		k =0;
                keypad(Frag_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==4){
                                noecho();
                        }
                        c = mvwgetch(Frag_win, 3, 15 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      wclear(Frag_win);
                                                      destroy_win(Frag_win);
                                                      break;
                                case KEY_BACKSPACE:
                                                   noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(Frag_win, 3, 15 + k);
                                                        wrefresh(Frag_win);
                                                        break;
                                case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 4){
                                                                get_frag[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == KEY_F(1))
                {
				value = pAppInfo->FragmentationThreshold;
                                wclear(Frag_win);
                                destroy_win(Frag_win);
                                redrawwin(conf_win);
                                break;
                }
         	if ( c == 10){
			     refresh();
			     switch(k)
			     {
			               case 1 :
			                           value = get_frag[0];
			                           break;
			               case 2 :
			                           value = 10 * get_frag[0] + get_frag[1];
			                           break;
			               case 3 :
			                           value = 100 * get_frag[0] + 10 * get_frag[1] + get_frag[2];
			                           break;
			               case 4 :
			                           value = 1000 * get_frag[0] + 100 * get_frag[1] + 10 * get_frag[2] + get_frag[3];
			                           break;
                                     default :
                                                   break;
                             }

                                wclear(Frag_win);
                                destroy_win(Frag_win);
                                redrawwin(conf_win);
                                break;
                }
        }

   	if ((value<256)||(value>2346))	{
	       wattron(error4_win,A_BOLD);
               wattron(error4_win, COLOR_PAIR(1));
		mvwprintw(error4_win, 2,22, "Invalid Value!!!");
		mvwprintw(error4_win, 4,23, "Press Any Key");
               wattroff(error4_win, COLOR_PAIR(1));
	       wattroff(error4_win,A_BOLD);
		wrefresh(error4_win);
		return -EINVAL;
   	}
   	pAppInfo->FragmentationThreshold=value;
   	strcpy(wrq.ifr_name,cname);
   	wrq.u.data.pointer = (caddr_t)pAppInfo;
   	wrq.u.data.length = sizeof(DEVICE_CONFIGURATION);
   	wrq.u.data.flags = SET_SUPPORT_INFO;
   	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
	       wattron(error4_win,A_BOLD);
               wattron(error4_win, COLOR_PAIR(1));
		mvwprintw(error4_win, 2,1, "Setting Fragmentation Threshold failed!!!");
		mvwprintw(error4_win, 4,23, "Press Any Key");
               wattroff(error4_win, COLOR_PAIR(1));
	       wattroff(error4_win,A_BOLD);
		wrefresh(error4_win);
		return -EIO;
   	}else{
		wclear(Frag_win);
		destroy_win(Frag_win);
                                redrawwin(conf_win);
	}

	//while(c = getch()){
//		if(c == KEY_F(1))
//		{
//			wclear(Frag_win);
//			destroy_win(Frag_win);
//			break;
//		}
//	}
	wattroff(Frag_win, A_BOLD);
   	return 0;
}

int Set_RtsT(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd)
{
	WINDOW *error5_win;
	struct iwreq	wrq;
	int c, k, value;
	int get_rts[4];
	
	error5_win = newwin(6, 60, 15, 4);
	box(error5_win, 0, 0);
	Rts_win = create_inputwin(6, 60,15, 4);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	wattron(Rts_win, A_BOLD);
	wattron(Rts_win, COLOR_PAIR(7));
	mvwprintw(Rts_win, 1, 30, "Cancel or Exit-> Press F1");
	wattroff(Rts_win, COLOR_PAIR(7));
	mvwprintw(Rts_win, 1,1, "Setting Rts/Cts Threshold.");
	mvwprintw(Rts_win, 2,1, "Valid values : (1 - 2347).");
	mvwprintw(Rts_win,3, 1, "Select value : ");
	wrefresh(Rts_win);
		k =0;
                keypad(Rts_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==4){
                                noecho();
                        }
                        c = mvwgetch(Rts_win, 3, 16 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      wclear(Rts_win);
                                                      destroy_win(Rts_win);
                                                      break;
                                case KEY_BACKSPACE:
                                                   noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(Rts_win, 3, 16 + k);
                                                        wrefresh(Rts_win);
                                                        break;
                                case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 4){
                                                                get_rts[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == KEY_F(1))
                {
                                value = pAppInfo->RtsCtsThreshold;
                                wclear(Rts_win);
                                destroy_win(Rts_win);
                                redrawwin(conf_win);
                                break;
                }
         	if ( c == 10){
	         refresh();
                             switch(k)
                             {
                                       case 1 :
                                                   value = get_rts[0];
                                                   break;
                                       case 2 :
                                                   value = 10 * get_rts[0] + get_rts[1];
                                                   break;
                                       case 3 :
                                                   value = 100 * get_rts[0] + 10 * get_rts[1] + get_rts[2];
                                                   break;
                                       case 4 :
                                                   value = 1000 * get_rts[0] + 100 * get_rts[1] + 10 * get_rts[2] + get_rts[3];
                                                   break;
                                     default :
                                                   break;
                             }

                                wclear(Rts_win);
                                destroy_win(Rts_win);
                                redrawwin(conf_win);
                                break;
                }
        }

   	
   	if ((value<1)||(value>2347)){
	       wattron(error5_win,A_BOLD);
               wattron(error5_win, COLOR_PAIR(1));
		mvwprintw(error5_win, 2,22, "Invalid Value!!!");
		mvwprintw(error5_win, 4,23, "Press Any Key");
               wattroff(error5_win, COLOR_PAIR(1));
	       wattroff(error5_win,A_BOLD);
		wrefresh(error5_win);
   		return -EINVAL;
   	}
   	
   	pAppInfo->RtsCtsThreshold=value;
   	strcpy(wrq.ifr_name,cname);
   	wrq.u.data.pointer = (caddr_t)pAppInfo;
   	wrq.u.data.length = sizeof(DEVICE_CONFIGURATION);
   	wrq.u.data.flags = SET_SUPPORT_INFO;
   	
   	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
	       wattron(error5_win,A_BOLD);
               wattron(error5_win, COLOR_PAIR(1));
		mvwprintw(error5_win, 2,1, "Setting Rts/Cts Threshold failed!!!");
		mvwprintw(error5_win, 4,23, "Press Any Key");
               wattroff(error5_win, COLOR_PAIR(1));
	       wattroff(error5_win,A_BOLD);
		wrefresh(error5_win);
   		return -EIO;
   	}else{
			wclear(Rts_win);
			destroy_win(Rts_win);
                                redrawwin(conf_win);
		}
//	while(c = getch()){
//		if(c == KEY_F(1))
//		{
//			wclear(Rts_win);
//			destroy_win(Rts_win);
//			break;
//		}
//	}
	wattroff(Rts_win, A_BOLD);
   	return 0;
}

int WepDlg(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pWepInfo)
{
	struct iwreq	wrq;
  	char 			Get_Arg[BUFSIZ], ep;
  	UCHAR 			W_KEY[LONG_WEP_KEY_SIZE];
  	int 			value;
	  int c;
        int d;
        int wep_utruth = 0;

        wep_reverse = 1;

        wep_win = create_newwin(18, 70, 6, 0);
        keypad(wep_win, TRUE);
        refresh();
        print_wep_menu(wep_win, wep_reverse);	
	
                while(1)
                {
                                d = wgetch(wep_win);
                                wep_utruth=0;
                                switch(d)
                                {
                                        case KEY_UP:
                                                        if(wep_reverse == 1)
                                                        wep_reverse = wep_config_choices;
                                                        else
                                                        --wep_reverse;
                                                        break;
                                        case KEY_DOWN:
                                                        if(wep_reverse == wep_config_choices)
                                                        wep_reverse = 1;
                                                        else
                                                        ++wep_reverse;
                                                        break;
                                        case 10:
                                                        wep_epilogh = wep_reverse;
                                                        wep_utruth=1;
                                                        break;
                                        default:
                                                        refresh();
                                                        break;
                                }
                                print_wep_menu(wep_win, wep_reverse);
                if(d == KEY_F(1))    /* User did a choice come out of the infinite loop */
                {
                        wclear(wep_win);
                        destroy_win(wep_win);
                        break;

                }
                if(wep_utruth==1){
                        if(wep_epilogh == 5)    /* User did a choice come out of the infinite loop */
                        {
                                wclear(wep_win);
                                destroy_win(wep_win);
                                wep_utruth = 0;
                                break;

                        }

		  switch(wep_epilogh)
                                {
                                        case 1:
			 			Set_Enc_Wep(pAppInfo, cname, fd, pWepInfo);
                                                refresh();
                                                break;
                                        case 2:
			 			Set_Wep_Value(pAppInfo, cname, fd, pWepInfo);
                                                refresh();
                                                break;
                                        case 3:
			 			Set_Wep_Mode(pAppInfo, cname, fd, pWepInfo);
                                                refresh();
                                                break;
                                        case 4:
			 			Set_Auth_Wep(pAppInfo, cname, fd, pWepInfo);
                                                refresh();
                                                break;
                                        default:
						refresh();
                                                break;
                                }
                        wep_utruth = 0;
                        }
                } //end while(1)
	return 0;
}
//************************* !proth***********************************
int Set_Enc_Wep(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pWepInfo)
{
	WINDOW *error9_win;
	struct iwreq	wrq;
	int c, k, value;
	int get_level[1];
	
	error9_win = newwin(6, 60,15, 4);	
	box(error9_win, 0, 0);
	enc_wep_win = create_inputwin(6, 60,15, 4);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	wattron(enc_wep_win, A_BOLD);
	wattron(enc_wep_win, COLOR_PAIR(7));
	mvwprintw(enc_wep_win, 1, 30, "Cancel or Exit-> Press F1");
	wattroff(enc_wep_win, COLOR_PAIR(7));
	mvwprintw(enc_wep_win, 1,1, "Enabling Wep Key.");
	mvwprintw(enc_wep_win, 2,1, "(0) No Encryption, (1) 64 bit, (2) 128 bit.");
	mvwprintw(enc_wep_win,3, 1, "Select Encryption level : ");
	wrefresh(enc_wep_win);

		k =0;
                keypad(enc_wep_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==1){
                                noecho();
                        }
                        c = mvwgetch(enc_wep_win, 3, 27 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      wclear(enc_wep_win);
                                                      destroy_win(enc_wep_win);
                                                      break;
                                case KEY_BACKSPACE:
                                                   noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(enc_wep_win, 3, 27 + k);
                                                        wrefresh(enc_wep_win);
                                                        break;
                                case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 1){
                                                                get_level[k]= c - '0';
                                                               // refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == KEY_F(1))
                {
                                value = pWepInfo->EncryptionLevel;
                                wclear(enc_wep_win);
                                destroy_win(enc_wep_win);
                                redrawwin(wep_win);
                                break;
                }
         	if ( c == 10){
				value = get_level[0];
                                wclear(enc_wep_win);
                                destroy_win(enc_wep_win);
                                redrawwin(wep_win);
                                break;
                }
        }


    		if((value < 0 )||(value > 2)){
	       wattron(error9_win,A_BOLD);
               wattron(error9_win, COLOR_PAIR(1));
		mvwprintw(error9_win, 2, 10, "Invalid Encryption Level!!!");
		mvwprintw(error9_win, 4,23, "Press Any Key");
               wattroff(error9_win, COLOR_PAIR(1));
	       wattroff(error9_win,A_BOLD);
		wrefresh(error9_win);
			return -EINVAL;
		}else{
                	pWepInfo->EncryptionLevel=value;
	    		strcpy(wrq.ifr_name,cname);
	                wrq.u.data.pointer = (caddr_t)pWepInfo;
        	        wrq.u.data.length = sizeof(WEP_INFO);
                	wrq.u.data.flags = SET_WEP_INFO;
			wclear(enc_wep_win);
			destroy_win(enc_wep_win);
                                redrawwin(wep_win);
			return;
		}

	  if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0)
                        {
		       wattron(error9_win,A_BOLD);
        	       wattron(error9_win, COLOR_PAIR(1));
   			mvwprintw(error9_win, 4, 5, "ioctl() Failed!!!! Exiting...");
			mvwprintw(error9_win, 4,23, "Press Any Key");
        	       wattroff(error9_win, COLOR_PAIR(1));
		       wattroff(error9_win,A_BOLD);
	}
	wattroff(enc_wep_win, A_BOLD);
   	return 0;
}
//*****************************!!!telos proths******************************

//*****************************!!!Deyterh*****************************
int Set_Wep_Value(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pWepInfo)
{
	WINDOW *error6_win;
	struct iwreq 	wrq;
	UCHAR  W_KEY[LONG_WEP_KEY_SIZE];
	int c, k, d, value;
	int get_value[1];

	error6_win = newwin(6, 60,15, 4);	
	box(error6_win, 0, 0);
	wep_value_win = create_inputwin(6, 60,15, 4);	
   			if (pWepInfo->EncryptionLevel==0){
				init_pair(7, COLOR_RED, COLOR_BLACK);
				wattron(error6_win, A_BOLD);
				wattron(error6_win, COLOR_PAIR(7));
				mvwprintw(error6_win, 2, 10, "Wep Key is Disabled. Enable it first");
				mvwprintw(error6_win, 4, 21, "Press Any Key");
				wattroff(error6_win, COLOR_PAIR(7));
				wrefresh(error6_win);				
				return -EINVAL;
			}
			init_pair(7, COLOR_RED, COLOR_BLACK);
			wattron(wep_value_win, A_BOLD);
			wattron(wep_value_win, COLOR_PAIR(7));
			mvwprintw(wep_value_win, 1, 1, "Cancel or Exit-> Press F1");
			wattroff(wep_value_win, COLOR_PAIR(7));
			mvwprintw(wep_value_win, 2, 1, "Wep Key to use (1, 2, 3 or 4 ): ");
				wrefresh(wep_value_win);				

		k =0;
                keypad(wep_value_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==1){
                                noecho();
                        }
                        c = mvwgetch(wep_value_win, 2, 33 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      wclear(wep_value_win);
                                                      destroy_win(wep_value_win);
                                                      break;
                                case KEY_BACKSPACE:
                                                   noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(wep_value_win, 2, 33 + k);
                                                        wrefresh(wep_value_win);
                                                        break;
                                case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 1){
                                                                get_value[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == KEY_F(1))
                {
                                value = pWepInfo->WepKeyToUse + 1;
                                wclear(wep_value_win);
                                destroy_win(wep_value_win);
                                redrawwin(wep_win);
                                break;
                }
         	if ( c == 10){
				value = get_value[0];
                                wclear(wep_value_win);
                                destroy_win(wep_value_win);
                                redrawwin(wep_win);
                                break;
                }
        }

				
		if ((value<1)||(value>4)){
		       wattron(error6_win,A_BOLD);
        	       wattron(error6_win, COLOR_PAIR(1));
   			mvwprintw(error6_win, 2,22, "Invalid Wep Key!!!");
			mvwprintw(error6_win, 4,23, "Press Any Key");
        	       wattroff(error6_win, COLOR_PAIR(1));
		       wattroff(error6_win,A_BOLD);
			wrefresh(error6_win);
			return -EINVAL;
		}
        	pWepInfo->WepKeyToUse= value-1;
    		strcpy(wrq.ifr_name,cname);
        	W_KEY[0]=pWepInfo->EncryptionLevel;
        	if(WEP_KEY_CONV(value, W_KEY)!=0){
		       wattron(error6_win,A_BOLD);
        	       wattron(error6_win, COLOR_PAIR(1));
   			mvwprintw(error6_win, 2,22, "Invalid Wep Key!!!");
			mvwprintw(error6_win, 4,23, "Press Any Key");
        	       wattroff(error6_win, COLOR_PAIR(1));
		       wattroff(error6_win,A_BOLD);
			wrefresh(error6_win);
			return -EINVAL;
		}
   		 	switch(pWepInfo->WepKeyToUse)
   		 	{
   		 		case 0:
   	            			memcpy(pWepInfo->WepKey1,W_KEY,LONG_WEP_KEY_SIZE);
					break;
   		        	case 1:
   		        		memcpy(pWepInfo->WepKey2,W_KEY,LONG_WEP_KEY_SIZE);
					break;
   		      		case 2:
   		        		memcpy(pWepInfo->WepKey3,W_KEY,LONG_WEP_KEY_SIZE);
					break;
   	        		case 3:
   	            			memcpy(pWepInfo->WepKey4,W_KEY,LONG_WEP_KEY_SIZE);
					break;
   	   		}
   	   		wrq.u.data.pointer = (caddr_t)pWepInfo;
   	        	wrq.u.data.length = sizeof(WEP_INFO);
   	        	wrq.u.data.flags = SET_WEP_INFO;
   	        	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
		       wattron(error6_win,A_BOLD);
        	       wattron(error6_win, COLOR_PAIR(1));
   			mvwprintw(error6_win, 4, 22, "ioctl() Failed!!!! Exiting...");
			mvwprintw(error6_win, 4,23, "Press Any Key");
        	       wattroff(error6_win, COLOR_PAIR(1));
		       wattroff(error6_win,A_BOLD);
			wrefresh(error6_win);
			return -EIO;
		}
	wattroff(wep_value_win, A_BOLD);
	wrefresh(wep_value_win);				
	return 0;
}   			
//*****************************************!!!telos deyterhs**********************

//*****************************************!!!trith**********************
int Set_Wep_Mode(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pWepInfo)
{
	WINDOW *error7_win;
	struct iwreq	wrq;
	int c, k, value;
	int get_wmode[1];
	
	error7_win = newwin(6, 60,15, 4);	
	box(error7_win, 0, 0);
	wep_mode_win = create_inputwin(6, 60,15, 4);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	wattron(wep_mode_win, A_BOLD);
	wattron(wep_mode_win, COLOR_PAIR(7));
	mvwprintw(wep_mode_win, 1, 1, "Cancel or Exit-> Press F1");
	wattroff(wep_mode_win, COLOR_PAIR(7));
	mvwprintw(wep_mode_win, 2,1, "Wep Mode (0 for Optional 1 for Mandatory): ");
	wrefresh(wep_mode_win);

		k =0;
                keypad(wep_mode_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==1){
                                noecho();
                        }
                        c = mvwgetch(wep_mode_win, 2, 44 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      wclear(wep_mode_win);
                                                      destroy_win(wep_mode_win);
                                                      break;
                                case KEY_BACKSPACE:
                                                   noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(wep_mode_win, 2, 44 + k);
                                                        wrefresh(wep_mode_win);
                                                        break;
                                case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 1){
                                                                get_wmode[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == KEY_F(1))
                {
                                value = pWepInfo->WepMode;
                                wclear(wep_mode_win);
                                destroy_win(wep_mode_win);
                                redrawwin(wep_win);
                                break;
                }
         	if ( c == 10){
				value = get_wmode[0];
                                wclear(wep_mode_win);
                                destroy_win(wep_mode_win);
                                redrawwin(wep_win);
                                break;
                }
        }

	
   	      		if((value<0)||(value>1)){
		       wattron(error7_win,A_BOLD);
        	       wattron(error7_win, COLOR_PAIR(1));
   			mvwprintw(error7_win, 2,22, "Invalid Wep Mode!!!");
			mvwprintw(error7_win, 4,23, "Press Any Key");
        	       wattroff(error7_win, COLOR_PAIR(1));
		       wattroff(error7_win,A_BOLD);
			wrefresh(error7_win);
			return -EINVAL;
   	      		} 
	   	        	pWepInfo->WepMode= value;
    				strcpy(wrq.ifr_name,cname);
   	        		wrq.u.data.pointer = (caddr_t)pWepInfo;
   	        		wrq.u.data.length = sizeof(WEP_INFO);
	   	        	wrq.u.data.flags = SET_WEP_INFO;
   		        	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
					       wattron(error7_win,A_BOLD);
        	       				wattron(error7_win, COLOR_PAIR(1));
   					mvwprintw(error7_win, 2, 22, "ioctl() failed!!! Exiting...");
						mvwprintw(error7_win, 4,23, "Press Any Key");
        	    				   wattroff(error7_win, COLOR_PAIR(1));
		       				wattroff(error7_win,A_BOLD);
						wrefresh(error7_win);
					wrefresh(wep_mode_win);
   	            		return -EIO;
   	      			}else{
					wclear(wep_mode_win);
					destroy_win(wep_mode_win);
                                redrawwin(wep_win);
				}
//	while(c = getch()){
//		if(c == KEY_F(1))
//		{
//			wclear(wep_mode_win);
//			destroy_win(wep_mode_win);
//			break;
//		}
//	}
	wattroff(wep_mode_win, A_BOLD);
   	return 0;
}

//*****************************************!!!telos triths**********************

//*****************************************!!!tetarths**********************

int Set_Auth_Wep(PDEVICE_CONFIGURATION pAppInfo, char *cname, int fd, PWEP_INFO pWepInfo)
{
	WINDOW *error8_win;
	struct iwreq	wrq;
	int c, k, value;
	int get_auth[1];
	
	error8_win = newwin(6, 60,19, 5);	
	box(error8_win, 0, 0);
	wep_auth_win = create_inputwin(6, 60,19, 5);	
	init_pair(7, COLOR_RED, COLOR_BLACK);
	wattron(wep_auth_win, A_BOLD);
	wattron(wep_auth_win, COLOR_PAIR(7));
	mvwprintw(wep_auth_win, 1, 30, "Cancel or Exit-> Press F1");
	wattroff(wep_auth_win, COLOR_PAIR(7));
	mvwprintw(wep_auth_win, 1,1, "Authentication Type");
	mvwprintw(wep_auth_win, 2,1, "Set Type (0 for Open System, 1 for Shared Key) : ");
	wrefresh(wep_auth_win);
		k =0;
                keypad(wep_auth_win, TRUE);
                while (1)
                {
                        echo();
                        if(k ==1){
                                noecho();
                        }
                        c = mvwgetch(wep_auth_win, 2, 50 + k);
                        switch(c)
                        {
                                case      KEY_F(1):
                                                      noecho();
                                                      wclear(wep_auth_win);
                                                      destroy_win(wep_auth_win);
                                                      break;
                                case KEY_BACKSPACE:
                                                   noecho();
                                                      if( k > 0 )
                                                      {
                                                        k--;
                                                        }
                                                        mvwdelch(wep_auth_win, 2, 50 + k);
                                                        wrefresh(wep_auth_win);
                                                        break;
                                case            10:
                                                        noecho();
                                                        break;
                                default           :
                                                         if ( k < 1){
                                                                get_auth[k]= c - '0';
                                                                refresh();
                                                                k++;
                                                        }else{
                                                                noecho();
                                                        }
                                                        break;
                        }
                if ( c == KEY_F(1))
                {
                                value = pWepInfo->AuthenticationType;
                                wclear(wep_auth_win);
                                destroy_win(wep_auth_win);
                                redrawwin(wep_win);
                                break;
                }
         	if ( c == 10){
				value = get_auth[0];
                                wclear(wep_auth_win);
                                destroy_win(wep_auth_win);
                                redrawwin(wep_win);
                                break;
                }
        }


   	      		if((value<0)||(value>1)){
		       wattron(error8_win,A_BOLD);
        	       wattron(error8_win, COLOR_PAIR(1));
   			mvwprintw(error8_win, 2, 22, "Invalid Authentication Type!!!");
			mvwprintw(error8_win, 4,23, "Press Any Key");
        	       wattroff(error8_win, COLOR_PAIR(1));
		       wattroff(error8_win,A_BOLD);
			wrefresh(error8_win);
			return -EINVAL;
   	      		}
   	      		pWepInfo->AuthenticationType = value;
    			strcpy(wrq.ifr_name,cname);
   	        	wrq.u.data.pointer = (caddr_t)pWepInfo;
   	        	wrq.u.data.length = sizeof(WEP_INFO);
   	       		wrq.u.data.flags = SET_WEP_INFO;
   	        	if (ioctl(fd, SIOCDEVPRIVATE, &wrq)<0){
		       wattron(error8_win,A_BOLD);
        	       wattron(error8_win, COLOR_PAIR(1));
   			mvwprintw(error8_win, 2, 22, "ioctl() failed!!! Exiting...");
			mvwprintw(error8_win, 4,23, "Press Any Key");
        	       wattroff(error8_win, COLOR_PAIR(1));
		       wattroff(error8_win,A_BOLD);
			wrefresh(error8_win);
   	        		return -EIO;
   	        	}else{
				wclear(wep_auth_win);
				destroy_win(wep_auth_win);
                                redrawwin(wep_win);
			}

//	while(c = getch()){
//		if(c == KEY_F(1))
//		{
//			wclear(wep_auth_win);
//			destroy_win(wep_auth_win);
//			break;
//		}
//	}
	wattroff(wep_auth_win, A_BOLD);
   	return 0;
}


//*****************************************!!!telos tetarths**********************

void print_wep_menu(WINDOW *wep_win, int wep_reverse)
{
    int x, y, i;
    x = 4;
    y = 3;
    box(wep_win, 0, 0);
    wattron(wep_win, A_BOLD);
    wattron(wep_win, COLOR_PAIR(2));
    mvwprintw(wep_win, 1, 21, "Wep Configuration Menu");
    wattroff(wep_win, COLOR_PAIR(2));
    mvwhline(wep_win, 2, 1, ACS_HLINE, 68);
    wattroff(wep_win, A_BOLD);
    for(i = 0; i < wep_config_choices; i++)
    {   if(wep_reverse == i + 1) /* High reverse the present choice */
        {    wattron(wep_win, A_REVERSE);
             wattron(wep_win, A_BOLD);
             mvwprintw(wep_win, y, x, "%s", wep_choices[i]);
             wattroff(wep_win, A_BOLD);
             wattroff(wep_win, A_REVERSE);
        }
       else
             mvwprintw(wep_win, y, x, "%s", wep_choices[i]);
        y++;
    }
        wrefresh(wep_win);
}
