/*
** ATOP - System & Process Monitor
**
** The program 'atop' offers the possibility to view the activity of
** the system on system-level as well as process-level.
**
** Include-file describing process-level counters maintained and functions
** to access the process-database.
** ================================================================
** Author:      Gerlof Langeveld - AT Computing, Nijmegen, Holland
** E-mail:      gerlof@ATComputing.nl
** Date:        November 1996
** LINUX-port:  June 2000
**
** This program is free software; you can redistribute it and/or modify it
** under the terms of the GNU General Public License as published by the
** Free Software Foundation; either version 2, or (at your option) any
** later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU General Public License for more details.
*/

#define	PNAMLEN		15
#define	CMDLEN		68

	/* 
	** structure containing only relevant process-info extracted 
	** from kernel's process-administration
	*/
struct pstat {
	/* GENERAL PROCESS INFO 					*/
	struct gen {
		int	pid;		/* process identification 	*/
		int	ruid;		/* real user  identification 	*/
		int	rgid;		/* real group identification 	*/
		char	name[PNAMLEN+1];/* process name string       	*/
		char 	state;		/* process state ('E' = exited)	*/
		long	excode;		/* process exit status		*/
		time_t 	btime;		/* process start time (epoch)	*/
		char	cmdline[CMDLEN+1];/* command-line string       	*/
	} gen;

	/* CPU STATISTICS						*/
	struct cpu {
		count_t	utime;		/* time user   text (ticks) 	*/
		count_t	stime;		/* time system text (ticks) 	*/
		int	pri;		/* priority                     */
		int	curcpu;		/* current processor            */
	} cpu;

	/* DISK STATISTICS						*/
	struct dsk {
		count_t	ior;		/* block I/O for read		*/
		count_t	iow;		/* block I/O for write		*/
	} dsk;

	/* MEMORY STATISTICS						*/
	struct mem {
		count_t	iosw;		/* number of swaps	 	*/
		count_t	minflt;		/* number of page-reclaims 	*/
		count_t	majflt;		/* number of page-faults 	*/
		count_t	shtext;		/* text     memory (Kb)         */
		count_t	vmem;		/* virtual  memory (Kb)		*/
		count_t	rmem;		/* resident memory (Kb)		*/
		count_t vgrow;		/* virtual  growth (Kb)    	*/
		count_t rgrow;		/* resident growth (Kb)     	*/
	} mem;

	/* NETWORK STATISTICS						*/
	struct net {
		count_t tcpsnd;		/* number of TCP-packets sent	*/
		count_t	tcprcv;		/* number of TCP-packets recved	*/
		count_t	udpsnd;		/* number of UDP-packets sent	*/
		count_t	udprcv;		/* number of UDP-packets recved	*/
	} net;
};

struct pinfo {
	struct pinfo	*phnext;	/* next process in hash    chain */
	struct pinfo	*prnext;	/* next process in residue chain */
	struct pinfo	*prprev;	/* prev process in residue chain */

	struct pstat	pstat;		/* per-process statistics        */
};


/*
** prototypes of process-database functions
*/
int	 pdb_getproc(int, struct pinfo **);
void	 pdb_addproc(int, struct pinfo *);
int	 pdb_delproc(int);
int	 pdb_newproc(struct pinfo **);
int	 pdb_makeresidue(void);
int	 pdb_cleanresidue(void);
int	 pdb_srchresidue(struct pstat *, struct pinfo **);

/*
** prototypes for raw process-statistics functions
*/
int	deviatproc(struct pstat *, int, struct pstat *, int, int,
					struct pstat *, int *);
int	photoproc(struct pstat *, int);
