/****************************************************************
**
** Attal : Lords of Doom
**
** main.cpp
** main file for ia
**
** Version : $Id: main.cpp,v 1.13 2006/03/09 21:07:11 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 29/12/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include <iostream>
using namespace std;
// include files for QT
#include <QApplication>
#include <QString>
#include <QDir>
#include <QLocale>
#include <QTranslator>
#include <QWidget>

// application specific includes
#include "conf.h"

#include "libCommon/attalCommon.h"

#include "ai/aiInterface.h"

extern QString DATA_PATH;
extern QString THEME;

QString PORT = "1717";
bool FAST = false;

int main( int argc, char **argv )
{
	QDir trfolder;
	trfolder = translationsDir(); 

	bool hide = false;
	QApplication app( argc, argv );
	QTranslator translator( 0 );
	translator.load( QString("attal_ai_") + QLocale::system().name(), trfolder.absolutePath() );

	app.installTranslator( &translator );

	for( int i = 1; i < argc; i++ ) {
		if( ( strcmp( argv[i], "-theme" ) == 0 ) || ( strcmp( argv[i], "--theme" ) == 0 ) ) {
			i++;
			if( i < argc )
				THEME = QString( argv[i] );
		} else if( ( strcmp( argv[i], "-port" ) == 0 ) || ( strcmp( argv[i], "--port" ) == 0 ) ) {
			i++;
			if( i < argc ){
				PORT = QString( argv[i] );
			}
		} else if( ( strcmp( argv[i], "-fast" ) == 0 ) || ( strcmp( argv[i], "--fast" ) == 0 ) ) {
			FAST = true;
		} else if( ( strcmp( argv[i], "-v" ) == 0 )  ) {	
			int level;
			level = atoi(argv[i+1]) ;
			setLogLevel((LogLevel) level ) ;
		} else if(  strcmp( argv[i], "--hide" ) == 0  ) {
			hide = true;
		} else if( ( strcmp( argv[i], "-help" ) == 0 ) || ( strcmp( argv[i], "--help" ) == 0 ) ) {
			cout << "Usage: attal-ai [OPTION]"  << endl;
			cout << "Start ai robot "  << endl;
			cout << endl;
			cout << "  -theme  --theme [NAME]      Load a particular theme (Medieval by default)"  << endl;
			cout << "  -port   --port [PORT]       Used to connect to a particular default port"  << endl;
			cout << "  -fast   --fast              Connect ai to localhost:1717"  << endl;
			cout << "  --hide                      Hide ai (remember to kill)"  << endl;
			cout << "  -v [LEVEL]                  Level of error messages (0-4) (default 4)"  << endl;
			cout << "  -help   --help              This screen"  << endl;
			return 1;
		}

	}
	useTheme();

	AiInterface game;
	//app.setMainWidget( &game );
	if(!hide) {
		game.show();
	}

	return app.exec();
}
