/****************************************************************
**
** Attal : Lords of Doom
**
** attal.cpp
** main file
**
** Version : $Id: main.cpp,v 1.13 2006/07/26 12:35:36 lusum Exp $
**
** Author(s) : Pascal Audoux - Cyrille Verrier - Sardi Carlo
**
** Date : 02/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include <iostream>
using namespace std;
// include files for QT
#include <QApplication>
#include <QDir>
#include <QString>
#include <QTextCodec>
#include <QTranslator>

#include <Q3Canvas>
// application specific includes
#include "libCommon/attalCommon.h"

#include "client/clientInterface.h"

extern QString THEME;
QString PORT = "1717";

#ifdef WITH_SOUND
extern bool ATT_SOUND;

#endif

int main( int argc, char **argv )
{
	QDir trfolder;
	trfolder = translationsDir(); 

	QApplication app( argc, argv );
	QTranslator translator( 0 );
	translator.load( QString("attal_client_") + QTextCodec::locale(), trfolder.absPath() );

	app.installTranslator( &translator );

	for( int i = 1; i < argc; i++ ) {
		if( ( strcmp( argv[i], "-theme" ) == 0 ) || ( strcmp( argv[i], "--theme" ) == 0 ) ) {
			i++;
			if( i < argc )
				THEME = QString( argv[i] );
		} else if( ( strcmp( argv[i], "-v" ) == 0 )  ) {	
			int level;
			level = atoi(argv[i+1]) ;
			setLogLevel((LogLevel) level ) ;
		} else if( ( strcmp( argv[i], "--nosound")  == 0 ) ) {
			#ifdef WITH_SOUND
			ATT_SOUND = false;
			#endif
		} else if( ( strcmp( argv[i], "-help" ) == 0 ) || ( strcmp( argv[i], "--help" ) == 0 ) ) {
			cout << "Usage: attal-client [OPTION]"  << endl;
			cout << "Start client "  << endl;
			cout << endl;
			cout << "  -theme  --theme [NAME]      Load a particular theme (Medieval by default)"  << endl;
			cout << "  -v [LEVEL]                  Level of error messages (0-4) (default 4)"  << endl;
			#ifdef WITH_SOUND
			cout << "  --nosound                   Disable totally sound (ex: for hardware problems)"  << endl;
			#endif
			cout << "  --help                      This screen"  << endl;
			return 1;
		}
	}

	useTheme();

	ClientInterface game;
	game.showMaximized();
	app.setMainWidget( &game );
	game.show();

	return app.exec();
}
