/****************************************************************
**
** Attal : Lords of Doom
**
** analyst.h
** analyse the game and play
**
** Version : $Id: analyst.h,v 1.5 2006/08/09 13:30:32 lusum Exp $
**
** Author(s) : Pascal Audoux - Carlo
**
** Date : 06/02/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef ANALYST_H
#define ANALYST_H
#define DIM 100
 

// generic include files
// include files for QT
//#include <QAbstractSocket>
#include <QList>
#include <QObject>

// application specific include files
#include "libCommon/artefact.h"
#include "libCommon/attalSocket.h"
#include "libCommon/log.h"

#include "libServer/gameData.h"
#include "libServer/fightAnalyst.h"
#include "libAi/aiLord.h"

extern Log aifLog;

class AttalSocket;
class FightAnalyst;
class GenericPlayer;
class GenericLord;
class GenericMap;
class Calendar;

/*              ------------------------------
 *                         Analyst
 *              ------------------------------ */

/** comment for the class */
class Analyst : public QObject, public GameData
{
	Q_OBJECT
public:

	/** Constructor */
	Analyst();
	
	/** Destructor */
	~Analyst();

	void reinitAi();
	
	void reinit();

	bool aiConnect( AttalSocket * sock );

	/** Set socket for exchanges with server */
	void setSocket( AttalSocket * sock ) {
		_socket = sock;
	}
	
	AttalSocket * getSocket () { return _socket; }

	/** Handle SO_MSG socket data */
	void socketMsg();

	/** Handle SO_CONNECT socket data */
	void socketConnect();

	/** Handle SO_MVT socket data */
	void socketMvt();
	
	/** Handle SO_TECHNIC socket data */
	void socketTechnic();
	
	/** Handle SO_FIGHT socket data */
	void socketFight();
	
	/** Handle SO_QR socket data */
	void socketQR();
	
	/** Handle SO_EXCH socket data */
	void socketExch();

	void socketGameInfo();

	void socketGameTavern();
	void socketGameCalendar();
	
	/** Handle SO_MODIF socket data */
	void socketModif();
	void socketModifMap();
	void socketModifCell();
	void socketModifLord();
	void socketModifLordVisit();
	void socketModifLordNew();
	void socketModifLordUnit();
	void socketModifLordRemove();
	void socketModifBase();
	void socketModifBaseNew();
	void socketModifBaseOwner();
	void socketModifBaseName();
	void socketModifBaseBuilding();
	void socketModifBaseUnit();
	void socketModifBasePopulation();
	void socketModifBaseProduction();
	void socketModifBuilding();
	void socketModifArtefact();
	void socketModifPlayer();
	void socketModifCreature();
	void socketModifEvent();
	void socketModifEventNew();
	void socketModifEventDel();

	/** Handle SO_TURN socket data */
	void socketTurn();
	void socketTurnBegin();

	/** Handle SO_GAME socket data */
	void socketGame();
	
	/* Return random enemy lord power */
	int getRandPower(GenericLord *lord);
	
	/* Return creature power */
	int getCreaturePower(GenericMapCreature * creature);
	
	GenericPlayer * getPlayer( uint num );
	
	/* Return exact lord power */
	int getPower(AiLord *lord);

	void exchangeStart();

	/** manage exchange units */
	void exchangeUnits();
	
	/** manage exchange artefact */
	void exchangeArtefact();
	
	void exchangeBaseUnits();

	void setPlayerNumber( uint nb );
	
	void manageBase(GenericBase * base);
	
	void enterBase(AiLord * lord,GenericBase * base );

public slots:

	/** Slot for reading sockets */
	void slot_readSocket();
	
private:

	class AiDataLord {
	public:
		/** constructor */
		AiDataLord( AiLord * lord );
		
		int rowFlee;
		int colFlee;
		int startApprRow;
		int startApprCol;
		int curPrior;
		int mincost;
		int fightCpt;
		GenericCell * destinationCell;
	};


	GenericArtefact * getArtefactById( int id );

	void playLordTurn(int nlord);

	void analyzeLord( AiLord * lord );
	
	void analyzeLordMap( AiLord * lord, AiDataLord * data );

	GenericCell * randomPath(AiLord * lord, AiDataLord * data );

	/* find if this is a cell reachable (and visible) near an unknown cell */
	GenericCell * findNearCellReach( GenericCell * cell );

	int noPath( GenericCell * cell );
	
	inline int flee( int src, int dst );

	/* manageMeetings
	 * with 
	 * lord =  our lord
	 * cell = target cell
	 * prior = priority of the target
	 * opPower = opponent power, 0 if no opponent
	 * isFlee = our lord flee if enemy is more powerful? true yes, false no (only care with opPower>0)
	 * data = struct of various ai param used and changed by this function
	 */
	 
	int manageMeetings( AiLord * lord, GenericCell * cell,int prior,int opPower, bool isFlee, AiDataLord * data );

	/* tell if the ai is in her turn (for coordinate lord's turn) */
	bool InTurn() { return _numTurn>=0 ? true : false; }

	AttalSocket * _socket;
	FightAnalyst * _fight;
	GenericPlayer * _player;
	GenericBase * _basetav;
	Calendar * _calendar;
	QString _msg;
	QList<AiLord *> _lordtav;
	uchar _nbLord, _nbLordRead;
	int _priorities[ AiLord::PR_LAST + 1 ];
	
	int _fightCpt;
	int _numlords;

	int _numTurn;
	int _SuffisantPower;
	int _totalTurn;
	
	//GenericMap * _map;
	//AiLord ** _lords;
	//QPtrList<GenericArtefact> _artefacts;
};

#ifdef WIN32
#define ialogV aifLog.ialog
#define ialogN aifLog.ialog
#define ialogC aifLog.ialog

#else

/** Log with level */
#define ialogV( format, args... ) aifLog.ialog( LOG_VERBOSE, format, ## args )
#define ialogN( format, args... ) aifLog.ialog( LOG_NORMAL, format, ## args )
#define ialogC( format, args... ) aifLog.ialog( LOG_CRITICAL, format, ## args )

#endif // WIN32

#endif // ANALYST_H   
