/****************************************************************
**
** Attal : Lords of Doom
**
** fightMapView.cpp
** subclass of QCanvasSprite that handles mouse event ...
**
** Version : $Id: fightMapView.h,v 1.4 2005/11/06 00:25:24 audoux Exp $
**
** Author(s) : Pascal Audoux - Cyrille Verrier
**
** Date : 17/10/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef FIGHTMAPVIEW_H
#define FIGHTMAPVIEW_H
 
 
// generic include files
// include files for QT
#include <Q3Canvas>
//Added by qt3to4:
#include <QMouseEvent>

// application specific includes
#include "libFight/fightMap.h"
#include "libFight/fightCell.h"

 
 
/*              ------------------------------
 *                         FightMapView
 *              ------------------------------ */



/** subclass of QCanvasView that handles mouse event ... */
class FightMapView : public Q3CanvasView
{
	Q_OBJECT
	
public:
	/** Constructor */
	FightMapView( FightMap * map, QWidget * parent = 0, const char * name = 0, Qt::WFlags f = 0 );
		
signals:
	/** Indicates where the mousw has been moved */
	void sig_mouseMoved( FightCell * cell );
	
	/** Indicates where the mouse has been presses with right button */
	void sig_mouseRightPressed( FightCell * cell );
	
	/** Indicates where the mouse has been presses with left button */
	void sig_mouseLeftPressed( FightCell * cell , bool isUnit);
	
	/** Indicated that the mouse has been released */
	void sig_mouseReleased();
	
	
protected:
	/** reimplemented : handles mouse event */
	void contentsMouseMoveEvent ( QMouseEvent *e );
	void contentsMouseReleaseEvent( QMouseEvent *e );
	void contentsMousePressEvent( QMouseEvent *e );
	
	bool _press;
};
 
#endif // FIGHTMAPVIEW_H   
