/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalGameData.cpp
** Manage data (graphically) of a whole game
**
** Version : $Id: graphicalGameData.cpp,v 1.11 2005/12/10 14:04:34 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 06/01/2002
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "graphicalGameData.h"
 
// generic include files
// include files for QT
#include <QTextStream>

// application specific include files
#include "libCommon/artefact.h"
#include "libCommon/dataTheme.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericEvent.h"
#include "libCommon/genericPlayer.h"
#include "libCommon/log.h"

#include "libClient/bonus.h"
#include "libClient/building.h"
#include "libClient/chest.h"
#include "libClient/event.h"
#include "libClient/graphicalArtefact.h"
#include "libClient/lord.h"
#include "libClient/map.h"
#include "libClient/mapCreature.h"

#include "libServer/questManager.h"



extern Map * theMap;
extern DataTheme DataTheme;

GraphicalGameData::GraphicalGameData()
	:GameData()
{
	reinit();
}

void GraphicalGameData::reinit()
{
	if( theMap ) {
		theMap->clear();
	}
	while( ! _players.isEmpty() ) {
		delete _players.takeFirst();
	}
	while( ! _bases.isEmpty() ) {
		delete _bases.takeFirst();
	}
	while( ! _buildings.isEmpty() ) {
		delete _buildings.takeFirst();
	}
	while( ! _lords.isEmpty() ) {
		delete _lords.takeFirst();
	}
	while( ! _events.isEmpty() ) {
		delete _events.takeFirst();
	}
	while( ! _creatures.isEmpty() ) {
		delete _creatures.takeFirst();
	}
	_calendar->reinit();
	_quests->clear();
	_nbPlayer = 0;
	_nbArtefact = 0;
	_nbBonus = 0;
	_nbChest = 0;
	for( int i = 0; i < DataTheme.lords.count(); i++ ) {
		Lord * lord = new Lord( theMap );
		lord->setId( i );
		lord->setVisible( false );
		_lords.append( (GenericLord*)lord );
	}
}

void GraphicalGameData::loadMap( QTextStream * stream, int width, int height )
{
	_map = (GenericMap *)theMap;
	theMap->clear();
	theMap->load( stream, width, height );
}	

void GraphicalGameData::addPlayer()
{
	_players.append( new GenericPlayer( _map ) );
}

GenericBase * GraphicalGameData::getNewBase()
{
	Base * base = new Base( theMap );
	_bases.append( (GenericBase*)base );
	return (GenericBase*)base;
}

/*
GenericEvent * GraphicalGameData::getNewEvent()
{
       //GenericArtefact * ret = (GenericArtefact *)( new Artefact( theMap ) );
       //ret->setId( _artefacts.count() );
       //_artefacts.append( ret );
       GenericEvent * ret = (GenericEvent *)( new Artefact( theMap ) );
       ret->setId( _artefacts.count() );
       _artefacts.append( ret );
       return ret;
}*/

GenericEvent * GraphicalGameData::getNewArtefact()
{
       GenericEvent * ret = (GenericEvent*) new Event();
       GenericArtefact * artefact = (GenericArtefact*) new Artefact( theMap );
       artefact->setId( _nbArtefact );
       _nbArtefact++;
       ret->setArtefact( artefact );
       _events.append( ret );
       return ret;
}

GenericEvent * GraphicalGameData::getNewBonus()
{
	GenericEvent * ret = (GenericEvent*) new Event();
	GenericBonus * bonus = (GenericBonus*) new Bonus( theMap );
	_nbBonus++;
	ret->setBonus( bonus );
	_events.append( ret );
	return ret;
}

GenericEvent * GraphicalGameData::getNewChest()
{
	GenericEvent * ret = (GenericEvent*) new Event();
	GenericChest * chest = (GenericChest*) new Chest( theMap );
	_nbBonus++;
	ret->setChest( chest );
	_events.append( ret );
	return ret;
}

GenericBuilding * GraphicalGameData::getNewBuilding()
{
	GenericBuilding * ret = (GenericBuilding *)( new Building( theMap ) );
	ret->setId( _buildings.count() );
	_buildings.append( ret );
	return ret;
}

GenericMapCreature * GraphicalGameData::getNewMapCreature()
{
	GenericMapCreature * ret = (GenericMapCreature *)( new MapCreature( theMap ) );
	_creatures.append( ret );
	return ret;
}



