/****************************************************************
**
** Attal : Lords of Doom
**
** miniMap.cpp
** draw and manage the mini-map
**
** Version : $Id: miniMap.cpp,v 1.4 2004/04/06 18:43:13 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 05/12/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "miniMap.h"

 
// generic include files
// include files for QT
#include <qpainter.h>
#include <qbrush.h>
// application specific includes
#include "libCommon/log.h"
#include "libCommon/dataTheme.h"

extern DataTheme DataTheme;

const int defaultHeight = 200;
const int defaultWidth = 200;

/** add comments here */
MiniMap::MiniMap( GenericMap * map, QWidget * parent, const char * name )
	: QWidget( parent, name )
{
	_map = map;

	setMaximumSize( 200, 200 );
	setFixedSize( 200, 200 );
	setBackgroundColor( Qt::black );

	_qp = new QPixmap( 200, 200 );
	_height = defaultHeight;
	_width = defaultWidth;
}

void MiniMap::resizeMap( uint width, uint height )
{
	_height = height;
	_width = width;
}

void MiniMap::redrawMap( GenericMap * map )
{
	int w = map->getWidth();
	int h = map->getHeight();

	if( isVisible() && ( w > 0 ) && ( h > 0 ) ) {
		_map = map;

		QPainter paint( _qp );
		QBrush brush;
		for( int i = 0; i < h; i++ ) {
			for( int j = 0; j < w; j++ ) {
				// XXX: to improve (color in theme ?)
				GenericCell * cell = map->at( i, j );
				if( cell->getType() < (int)( DataTheme.tiles.count() ) ) {
					redrawCell( cell );
				} else {
					logEE( "Each cell should have a type" );
				}
			}
		}
		bitBlt( this, 0, 0, _qp );
	}
}


void MiniMap::redrawCell( GenericCell * cell )
{
	uint w = _map->getWidth();
	uint h = _map->getHeight();
	uint row = cell->getRow();
	uint col = cell->getCol();

	if( isVisible() && ( w > 0 ) && ( h > 0 ) ) {
		int sizeH = _width/w;
		int sizeV = _height/h;

		QPainter paint( _qp );
		QBrush brush;

		// XXX: to improve (color in theme ?)
		if( cell->getType() < (int)( DataTheme.tiles.count() ) ) {
			if( cell->getType() == 0 ) {
				paint.fillRect( col * sizeH, row * sizeV, sizeH, sizeV, Qt::black );
			} else  {
				QColor c = DataTheme.tiles.at( cell->getType() )->getColor();
				paint.fillRect( col * sizeH, row * sizeV, sizeH, sizeV, c );
			}
		} else {
			logEE( "Each cell should have a type" );
		}
		bitBlt( this, 0, 0, _qp );
	}
}

void MiniMap::paintEvent( QPaintEvent * event )
{
	QWidget::paintEvent( event );
	bitBlt( this, 0, 0, _qp );
}

void MiniMap::resizeEvent( QResizeEvent * event )
{
	QWidget::resizeEvent( event );
	_qp->resize( event->size() );
	_qp->fill( Qt::black );
	bitBlt( this, 0, 0, _qp );
}

void MiniMap::mouseReleaseEvent( QMouseEvent * event )
{
	QWidget::mouseReleaseEvent( event );
}

void MiniMap::mousePressEvent( QMouseEvent * event )
{
	uint w = _map->getWidth();
	uint h = _map->getHeight();
	QWidget::mousePressEvent( event );
	if(w && h){  
		int sizeH = _width/w;
		int sizeV = _height/h;
		GenericCell * cell = _map->at(event->y()/sizeV,event->x()/sizeH);
		emit sig_mouseReleasedMinimap( cell );
	}
}
