/****************************************************************
**
** Attal : Lords of Doom
**
** sectionDecoration.cpp
** section for specifying decorations
**
** Version : $Id: sectionDecoration.cpp,v 1.5 2003/09/27 21:05:11 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 02/06/2001
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "sectionDecoration.h"

// generic include files
// include files for QT
#include <qlayout.h>

// application specific include files
#include "libCommon/dataTheme.h"
#include "libCommon/genericDecoration.h"
#include "libCommon/log.h"

#include "libClient/imageTheme.h"

#include "themeEditor/decorationEffect.h"

extern DataTheme DataTheme;
extern ImageTheme ImageTheme;
extern QString IMAGE_PATH;

//
// ----- SectionDecoration -----
//

SectionDecoration::SectionDecoration( QWidget * parent , const char * name )
	: GenericSection( parent, name )
{
	_num = 0;
	
	setTitle( tr( "Decoration" ) );

	QVBoxLayout * layout = new QVBoxLayout( _mainWidget );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );

	_name = new AskString( tr( "Name: " ), _mainWidget );
	layout->addWidget( _name );

	_info = new AskString( tr( "Info: " ), _mainWidget );
	layout->addWidget( _info );

	_decorationEffect = new DecorationEffect( _mainWidget );
	layout->addWidget( _decorationEffect );

	_image = new AskPixmap( true, "", tr( "Image: " ), _mainWidget );
	layout->addWidget( _image );

	layout->addStretch( 1 );
	layout->activate();
	
	init();
}

void SectionDecoration::clear()
{
	_name->setValue( "" );
	_info->setValue( "" );
}

void SectionDecoration::init()
{
	if( DataTheme.decorations.count() > 0 ) {
		GenericDecoration * decor = DataTheme.decorations.at( _num );
		_name->setValue( decor->getName() );
		_info->setValue( decor->getInfo() );
		_decorationEffect->init( decor );
		QString dest = IMAGE_PATH + QString( "decor/decoration_" ) + QString::number( _num + 1 ) + QString( ".png" );
		_image->setDestination( dest );
	}
}

void SectionDecoration::save()
{
	if( DataTheme.decorations.count() > 0 ) {
		GenericDecoration * decor = DataTheme.decorations.at( _num );
		decor->setName( _name->getValue() );
		decor->setInfo( _info->getValue() );
		_decorationEffect->save();
		_image->save();
	}
}

void SectionDecoration::selectFirst()
{
	save();
	_num = 0;
	init();
}

void SectionDecoration::selectPrevious()
{
	save();
	_num = (uint)QMAX( 0, (int)_num - 1 );
	init();
}

void SectionDecoration::selectNext()
{
	save();
	_num = QMIN( DataTheme.decorations.count() - 1, _num + 1 );
	init();
}

void SectionDecoration::selectLast()
{
	save();
	_num = DataTheme.decorations.count() - 1;
	init();
}

void SectionDecoration::selectNew()
{
	save();
	GenericDecoration * decor = new GenericDecoration();
	_num = DataTheme.decorations.count();
	DataTheme.decorations.append( decor );
	clear();
}

void SectionDecoration::selectDel()
{
	if( DataTheme.decorations.count() > 0 ) {
		DataTheme.decorations.remove( _num );
		_num = QMIN( _num, DataTheme.decorations.count() - 1 );
		init();
	}
}









