/****************************************************************
**
** Attal : Lords of Doom
**
** gameData.h
** Manage data of a whole game
**
** Version : $Id: gameData.h,v 1.6 2004/10/08 23:02:04 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 05/01/2002
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef GAMEDATA_H
#define GAMEDATA_H
 
 
// generic include files
// include files for QT
#include <qstring.h>
#include <qptrlist.h>
// application specific include files
#include "libCommon/genericEvent.h"
#include "libCommon/log.h"

class QTextStream;

class GenericBase;
class GenericBuilding;
class GenericCell;
class GenericLord;
class GenericMap;
class GenericMapCreature;
class GenericPlayer;
class Quest;
class QuestManager;
class ScenarioParser;

/**              ------------------------------
 *                          GameData
 **              ------------------------------ */

class GameData
{

public:
	/** Constructor */
	GameData();

	virtual ~GameData();

	void save( QTextStream * ts );

	/** Reinit data (new game) */
	virtual void reinit();
	
	/** Set the name of the scenario */
	void setScenarioName( const QString & name ) { _scenarioName = name; }
	
	/** Return the name of the scenario */
	QString getScenarioName() { return _scenarioName; }
	
	/** Set the description of the scenario */
	void setScenarioDescription( const QString & desc ) { _scenarioDescription = desc; }
	
	/** Return the description of the scenario */
	QString getScenarioDescription() { return _scenarioDescription; }
	
	/** Set the theme used by the scenario */
	void setScenarioTheme( QString theme ) { _scenarioTheme = theme; }

	/** Return the theme used by the scenario */
	QString getScenarioTheme() { return _scenarioTheme; }

	virtual void addPlayer() {}

	virtual void setNbPlayer( int nb ) { _nbPlayer = nb; }

	virtual uint getNbPlayer() { return _nbPlayer; }

	virtual GenericCell * getCell( uint row, uint col );	

	virtual uint getBaseNumber();

	virtual void loadMap( QTextStream * stream, int width, int height );
	
	virtual GenericBase * getNewBase();
	
	virtual void setBase2Player( int idBase, int player );
	
	virtual void setBuilding2Player( int idBuild, int player );
	
	GenericLord * getLord( int idLord );

	GenericPlayer * getPlayer( int num );
	
	virtual void setLord2Player( int idLord, int player ); 
	
	virtual GenericEvent * getNewArtefact();

	virtual GenericEvent * getNewBonus();

	virtual GenericEvent * getNewChest();

	virtual GenericBuilding * getNewBuilding();

	virtual Quest * getNewQuest();

	Quest * getMainQuest();

	virtual GenericMapCreature * getNewMapCreature();

protected:
	int _nbPlayer;
	uint _nbArtefact, _nbBonus, _nbChest;
	GenericMap * _map;
	QPtrList<GenericPlayer> _players;
	QPtrList<GenericBase> _bases;
	QPtrList<GenericBuilding> _buildings;
	QPtrList<GenericLord> _lords;
	QPtrList<GenericEvent> _events;
	QPtrList<GenericMapCreature> _creatures;
	QuestManager * _quests;
       	QString _scenarioName, _scenarioTheme, _scenarioDescription;	
};
 
#endif // GAMEDATA_H   
