#ifndef AUD_WMA_FMT_H
#define AUD_WMA_FMT_H

#include <glib-2.0/glib.h>

#define ASF_HEADER_OBJECT_GUID				"75B22630-668E-11CF-A6D900AA0062CE6C"
#define ASF_FILE_PROPERTIES_OBJECT_GUID			"8CABDCA1-A947-11CF-8EE400C00C205365"
#define ASF_STREAM_PROPERTIES_OBJECT_GUID		"B7DC0791-A9B7-11CF-8EE600C00C205365"
#define ASF_HEADER_EXTENSION_OBJECT_GUID		"5FBF03B5-A92E-11CF-8EE300C00C205365"
#define ASF_CODEC_LIST_OBJECT_GUID			"86D15240-311D-11D0-A3A400A0C90348F6"
#define ASF_SCRIPT_COMMAND_OBJECT_GUID			"1EFB1A30-0B62-11D0-A39B00A0C90348F6"
#define ASF_MARKER_OBJECT_GUID				"F487CD01-A951-11CF-8EE600C00C205365"
#define ASF_BITRATE_MUTUAL_EXCLUSION_OBJECT_GUID	"D6E229DC-35DA-11D1-903400A0C90349BE"
#define ASF_ERROR_CORRECTION_OBJECT_GUID		"75B22635-668E-11CF-A6D900AA0062CE6C"
#define ASF_CONTENT_DESCRIPTION_OBJECT_GUID		"75B22633-668E-11CF-A6D900AA0062CE6C"
#define ASF_EXTENDED_CONTENT_DESCRIPTION_OBJECT_GUID	"D2D0A440-E307-11D2-97F000A0C95EA850"
#define ASF_CONTENT_BRANDING_OBJECT_GUID		"2211B3FA-BD23-11D2-B4B700A0C955FC6E"
#define ASF_STREAM_BITRATE_PROPERTIES_OBJECT_GUID	"7BF875CE-468D-11D1-8D82006097C9A2B2"
#define ASF_CONTENT_ENCRYPTION_OBJECT_GUID		"2211B3FB-BD23-11D2-B4B700A0C955FC6E"
#define ASF_EXTENDED_CONTENT_ENCRYPTION_OBJECT_GUID	"298AE614-2622-4C17-B935DAE07EE9289C"
#define ASF_DIGITAL_SIGNATURE_OBJECT_GUID		"2211B3FC-BD23-11D2-B4B700A0C955FC6E"
#define ASF_PADDING_OBJECT_GUID				"1806D474-CADF-4509-A4BA9AABCB96AAE8"

typedef enum{
	ASF_HEADER_OBJECT = 0,
	ASF_FILE_PROPERTIES_OBJECT,
	ASF_STREAM_PROPERTIES_OBJECT,
	ASF_HEADER_EXTENSION_OBJECT,
	ASF_CODEC_LIST_OBJECT,
	ASF_SCRIPT_COMMAND_OBJECT,
	ASF_MARKER_OBJECT,
	ASF_BITRATE_MUTUAL_EXCLUSION_OBJECT,
	ASF_ERROR_CORRECTION_OBJECT,
	ASF_CONTENT_DESCRIPTION_OBJECT,
	ASF_EXTENDED_CONTENT_DESCRIPTION_OBJECT,
	ASF_CONTENT_BRANDING_OBJECT,
	ASF_STREAM_BITRATE_PROPERTIES_OBJECT,
	ASF_CONTENT_ENCRYPTION_OBJECT,
	ASF_EXTENDED_CONTENT_ENCRYPTION_OBJECT,
	ASF_DIGITAL_SIGNATURE_OBJECT,
	ASF_PADDING_OBJECT,
	ASF_OBJECT_LAST /* dummy */
}obj_type;

typedef struct _object_type{
obj_type object_type;
gchar *guid_value;
} ObjectType; 

extern const ObjectType object_types_map[ASF_OBJECT_LAST];

typedef struct contentDescriptionObjUTF8
{
	guint64 size;
	guint16 title_length;
	guint16 author_length;
	guint16 copyright_length;
	guint16 desc_length;
	guint16 rating_length;
	gchar *title; //wchar 16 bit
	gchar *author;
	gchar *copyright;
	gchar *description;
	gchar *rating;
}ContentDescriptionUTF8;

typedef struct contentDescriptionObjUTF16
{
	guint64 size;
	guint16 title_length;
	guint16 author_length;
	guint16 copyright_length;
	guint16 desc_length;
	guint16 rating_length;
	gunichar2 *title;
	gunichar2 *author;
	gunichar2 *copyright;
	gunichar2 *description;
	gunichar2 *rating;
}ContentDescriptionUTF16;

#endif /* WMA_FMT_H */
