/*
 *  ap_config.c
 *
 *  Copyright 2009 Arnaud Soyez <weboide@codealpha.net>
 *
 *  This file is part of AudioPreview.
 *
 *  AudioPreview is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  AudioPreview is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AudioPreview.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "ap_config.h"
#include <glib/gi18n-lib.h>
#include "functions.h"

#define PREVIEW_DURATION 10

void ap_config_init (apconfig* ap)
{
  // Some initialization
  ap->verbose  = FALSE;
  ap->debug    = FALSE;
  ap->quiet    = FALSE;
  ap->duration = PREVIEW_DURATION;
  ap->position = START_PLAYING_ANYWHERE;
  ap->fastseek = FALSE;
  ap->no_audio = FALSE;
  /* if DISPLAY is not defined, do not show video, this will avoid Gst errors */
  ap->no_video = (!getenv ("DISPLAY") || strlen(getenv ("DISPLAY")) == 0);
  ap->entirely = FALSE;
  ap->shuffle  = FALSE;
  ap->loop     = FALSE;
  ap->colors   = "auto";
  ap->want_colors = need_colors (ap->colors);
  ap->volume   = 100;
  ap->maxduration = -1;
  ap->terminal_cols = get_terminal_width();
  ap->playlist_from_file = NULL;
  tcgetattr (STDIN_FILENO, &ap->savedttystate);
}

void config_check_volume ()
{
  if (ap_config.volume < 0)
  {
    g_warning (_("Volume cannot be negative. It has been set to 0."));
    ap_config.volume = 0;
  }
  else if (ap_config.volume > 200)
  {
    g_warning (_("Volume cannot be greater than 200%%. It has been set to 200."));
    ap_config.volume = 200;
  }
}

void config_check_start_position()
{
  switch (ap_config.position)
  {
    default:
    {
      g_warning (_("Unknown start position (%d)! Forced to %d (ANYWHERE)."),
                                                  ap_config.position,
                                                  START_PLAYING_ANYWHERE);
      ap_config.position = START_PLAYING_ANYWHERE;
      break;
    }
    
    case START_PLAYING_START:
    {
      g_debug ("StartPosition: START_PLAYING_START");
      break;
    }
    
    case START_PLAYING_MIDDLE:
    {
      g_debug ("StartPosition: START_PLAYING_MIDDLE");
      break;
    }
    
    case START_PLAYING_END:
    {
      g_debug ("StartPosition: START_PLAYING_END");
      break;
    }
    
    case START_PLAYING_ANYWHERE:
    {
      g_debug ("StartPosition: START_PLAYING_ANYWHERE");
      break;
    }
  }
  
}
