#include <stdlib.h>
#include <curses.h>
#include <audacious/audctrl.h>
#include <string.h>
#include <libgen.h>
#include "curses_printf.h"
#include "main.h"
#include "playlist.h"
#include "dbus.h"

/*
    This file is part of xmms-curses, copyright 2003-2005 Knut Auvor Grythe.

    xmms-curses is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    xmms-curses is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with xmms-curses; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

extern playlist list;
extern windows wins;
extern prefs settings;

int song_length(int song)
{
	if(song == -1) return 0;
	if(list.song[song].length == 0){
		list.song[song].length = (int) audacious_remote_get_playlist_time(dbus_proxy, (gint) song)/1000;
	}
	return list.song[song].length;
}

char *song_title(int song)
{ 
	if (song == -1) return "No song loaded...";
	if (strlen(list.song[song].title) == 0) {
		free(list.song[song].title);
		if (settings.read_title) {
			list.song[song].title = audacious_remote_get_playlist_title(dbus_proxy, (gint) song);
		} else {
			char *tmp = strdup(list.song[song].file);
			char *end = strrchr(tmp, '.');
			*end = '\0';
			list.song[song].title = strdup(basename(tmp));
			free(tmp);
		}
	}
	
	return list.song[song].title;
}

static int playlist_pos(int *songs, int pos)
{
	if (songs == NULL)
		return pos;
	else
		return songs[pos];
}

void playlist_paint(playlist *plist) 
{ 	
	int i, width, height;
	getmaxyx(wins.list, height, width);
	
	if (plist->pos != plist->prev_pos && 
			(plist->pos < plist->scrolledto || plist->pos >= plist->scrolledto+height)) {
		plist->scrolledto = plist->pos - height/2;
	} else if (plist->selector >= (plist->scrolledto+height)){
		plist->scrolledto = plist->selector-height+1;
	} else if (plist->selector < plist->scrolledto) {
		plist->scrolledto = plist->selector;
	}
	
	if (plist->scrolledto > plist->length - height) {
		plist->scrolledto = plist->length - height;
	} 
	
	if (plist->scrolledto < 0) {
		plist->scrolledto = 0;
	}
	
	for (i=0; i<height; i++) {
		int hits_song = i+plist->scrolledto;
		int list_song = playlist_pos(plist->song_mask, hits_song);
		
		if (hits_song >= plist->length) {
			wmove(wins.list, i, 0);
			wclrtoeol(wins.list);
			wchgat(wins.list, -1, A_NORMAL, 1, NULL);
			continue;
		}

		// print playlist entries
		wmove(wins.list, i, 0);
		if (settings.show_numbers && plist->song_mask == NULL)
			waddnstrf(wins.list, "%d. ", -1, list_song+1);
		waddnstr(wins.list, song_title(list_song), -1);
		wclrtoeol(wins.list);
		if (settings.read_length)
			mvwaddstrf(wins.list, i, width-6, " %02i:%02i", 
				song_length(list_song)/60, (song_length(list_song)%60));
		
		// color playlist entries
		if (hits_song == plist->selector) {
			mvwchgat(wins.list, i, 0, -1, A_REVERSE, 2, NULL);
		} else if (hits_song == plist->pos) {
			mvwchgat(wins.list, i, 0, -1, A_BOLD, 1, NULL);
		} else {
			mvwchgat(wins.list, i, 0, -1, A_NORMAL, 1, NULL);
		}
	}

	wnoutrefresh(wins.list);
}

void playlist_read(int length)
{
	int i;

	for(i=0; i<list.length; i++){
		free(list.song[i].title);
		free(list.song[i].file);
	}
	list.song = (song*) realloc(list.song, sizeof(song)*length);
	for (i=0; i<length; i++) {
		list.song[i].file =  audacious_remote_get_playlist_file(dbus_proxy, (gint) i);
		list.song[i].title = malloc(sizeof(char));
		strcpy(list.song[i].title, "");
		list.song[i].length = 0;
		if (settings.read_all) {
			if (settings.read_title)
				song_title(i);
			if (settings.read_length)
				song_length(i);
		}
	}
	list.length = length;
    return;
}

