#!/usr/bin/env python
# Copyright (C) Andrew Mitchell 2006

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.

#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
############################################################################

## DNS Lookups for services 
# Future tasks is to configure DNS services also
# Records are in this format:
#  _kerberos._udp          IN SRV  01 00 88 auth-server.localdomain.
#  _kerberos._tcp          IN SRV  01 00 88 auth-server.localdomain.
#  _kpasswd._udp           IN SRV  01 00 464 auth-server.localdomain.
#  _kerberos-adm._tcp      IN SRV  01 00 749 auth-server.localdomain.
#  _kerberos               IN TXT  LOCALDOMAIN


# Use python-dnspython
import sys
import dns.name
import dns.resolver

class DNSConfig(object):

    def __init__(self):
        pass


    def SRV(self, service, protocol='tcp', domain=''):
        results = {'fdqn':'',
                   'priority':'',
                   'port':'',
                   'host':''}
        # turn it into _service._protocol.domain
        if domain != '':
            domain = '.%s' % domain
        q = '_%s._%s%s' % (service, protocol, domain)
        #print q
        try:
            answer = dns.resolver.query(q, 'SRV')
            info = str(answer.rrset).split()
            results['fqdn'] = info[0]
            results['priority'] = info[4]
            results['port'] = info[6]
            results['host'] = info[7]
        except:
            pass
    
        return results
            

    def TXT(self, service, domain=''):
        results = {'txt':''}
        # turn it into _service.domain
        if domain != '':
            domain = '.%s' % domain
        q = '_%s%s' % (service, domain)
        #print q
        try:
            answer = dns.resolver.query(q, 'TXT')
            # want to get the kerberos REALM
            info = str(answer.rrset).split()
            results['txt'] = info[4]
        except:
            pass
            
        return results


if __name__ == '__main__':
    d = DNSConfig()
    print d.TXT('kerberos')

    print d.SRV('kerberos')
    print d.SRV('ldap')
