#!/usr/bin/env python

from distutils.core import setup
import glob
import os
import re

# look/set what version we have
changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)
        f=open("AuthTool/Version.py","w")
        f.write("VERSION=\"%s\"\n" % version)
        f.write("INSTALLED=True")
        f.close()


GETTEXT_NAME="authtool"
I18NFILES = []
methods = []
files = os.listdir('auth_methods')
for method in files:
    if (method[-3:] != '.py') and (method[-4:] != '.pyc'):
        m_dir = method
        m_files = ['auth_methods/%s/%s' % (method,m) for m in os.listdir('auth_methods/%s' % m_dir) if m[-4:] != '.pyc']
        methods.append( ("/usr/share/authtool/auth_methods/"+method, m_files) )

for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    I18NFILES.append((targetpath, [filepath]))

# we should probably only run those os.system() stuff when "build" is
# the cmndline argument
#os.system("intltool-merge -x po data/authtool.xml.in"\
#                       " build/authtool.xml")
#os.system("intltool-merge -d po data/authtool.desktop.in"\
#                       " build/authtool.desktop")
# HACK: make sure that the mo files are generated and up-to-date
#os.system("cd po; make update-po")

print methods
setup(name='authtool',
      version=version,
      description='Network Authentication Configuration',
      author='Andrew Mitchell',
      author_email='ajmitch@ubuntu.com',
      packages=['AuthTool'],
      #package_data={'auth_methods':'auth_methods/*'},
      scripts=['authtool','authtool-gtk'],
      data_files=[
    ('share/applications',["data/authtool.desktop"]),
    ('/etc/authtool',['data/authtools.conf']),
    ('/usr/share/authtool',['auth_methods/__init__.py']),
    ('/usr/share/authtool/auth_methods',['auth_methods/__init__.py']),
    ('share/pixmaps',['data/authtool.png'])]+I18NFILES+methods,
      )


