# 25.0.0

## Major
 - Switch versioning system from "CalVer weeks of the year" to SemVar.

## Features
 - Make temp directories lazily. This will mean a temp directory is not created at all in some cases.
 - Add the `--no-cache` option. When set, will prevent auto-editor from reading from or writing to a cache file.

## Fixes
 - Step around PyAV bug when getting pix_fmt. Fixes #489
 - Add `hevc_nevc` as a known encoder. Fixes #490
 - The cache is twice as small as the equivalent 24w31a would write.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w31a...25.0.0


# 24w31a

## What's Changed
 - Bug fix: never set the color primary if the value is 0
 - Palet: add `max-seq` and `min-seq` procedures

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w30a...24w31a


# 24w30a

## What's Changed
 - Upgrade to PyAV 12.3
 - Use PyAV to get encoder information instead of maintaining a big list
 - Audio analysis no longer writes a temporary WAV file

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w29a...24w30a


# 24w29a

## What's Changed
 - Use numpy's `.npz` for smaller and faster caching
 - Add `audio-levels` `motion-levels` to Palet
 - In general, remove lines of code

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w25a...24w29a


# 24w25a

## What's Changed
 - Only extract subtitle files when needed
 - Analyze subtitles robustly, don't rely on hacky methods
 - Assert generated timeline is monotonic (fixes #470)
 - Errors are now colored, will be disabled if NO_COLOR or AV_LOG_FORCE_NOCOLOR environment variable is set

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w24a...24w25a


# 24w24a

## What's Changed
 - Use `pyav` 12.1.0, the first release that is compatible with `av`
 - Handle import v1 timelines better

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w19a...24w24a


# 24w19a

## What's Changed
 - Round timebase to two-digits, which should fix a Premiere Pro issue
 - v3 format: offset is no longer implicitly multiplied by clip speed
 - Consider `libopus` a valid encoder

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w13a...24w19a


# 24w13a

## What's Changed
 - Color space handling has been improved
 - Having ffprobe is no longer required
 - `auto-editor subdump` now only uses/requires PyAV

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w09a...24w13a


# 24w09a

## What's Changed
 - By default, all tracks will now be considered when editing audio
 - Premiere Export: Fix 24w07a regression where only a single audio channel would play
 - Auto-Editor will now never attempt to copy attachments unless subtitle streams are present
 - `audio` `motion` `subtitle` are now no longer special lexer constructs

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w07a...24w09a


# 24w07a

## What's Changed
 - Fix crash on certain resolutions for legacy macs
 - Final Cut Export: always set "start" attribute even when value is 0
 - Premiere Export: additional tracks no longer need external wavs
 - Fix crash for all `.ts` media files

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/24w03a...24w07a


# 24w03a

## What's Changed
 - Analyzing motion is now 1.3x faster.
 - Changing the aspect ratio (adding padding) is now 2.7x faster.
 - Better support for the `yuv444p` `yuvj444p` pix_fmt's
 - Dropped the Pillow dependency
 - Upgrade pyav to 12.0.2

## Breaking Changes
 - Removed `--mark-as-loud` and `--mark-as-silent`. Use `--add-in`, `--cut-out` instead.
 - Removed `pixeldiff` as an option for `--edit`. Use `motion` instead.

**Full Changelog**: https://github.com/WyattBlue/auto-editor/compare/23w51a...24w03a
