# -*- coding:utf-8 -*-

%define AMC_modsdir %{_libdir}/AMC
%define AMC_modelsdir /usr/share/auto-multiple-choice/models
%define AMC_texdir /usr/share/texmf/tex/latex/AMC
%define AMC_bindir %{_bindir}
%define AMC_pixdir /usr/share/pixmaps
%define AMC_iconsdir /usr/share/auto-multiple-choice/icons

%if 0%{?fedora}
%define AMC_perldir %{perl_privlib}
%else
%define AMC_perldir %{perl_vendorlib}
%endif

%define AMC_man1dir %{_mandir}/man1
%define AMC_docdir %{_docdir}/%{name}


%if 0%{?suse_version}
%define AMC_cat Education;Teaching;
%else
%define AMC_cat Education;
%endif

%define AMC_makepass SYSTEM_TYPE=rpm MODSDIR=%{AMC_modsdir} MODELSDIR=%{AMC_modelsdir} TEXDIR=%{AMC_texdir} BINDIR=%{AMC_bindir} ICONSDIR=%{AMC_iconsdir} PIXDIR=%{AMC_pixdir} PERLDIR=%{AMC_perldir} MAN1DIR=%{AMC_man1dir} DOCDIR=%{AMC_docdir} DESKTOPDIR="" DESKTOP_CAT="%{AMC_cat}"

Name: auto-multiple-choice
Summary: Auto Multiple Choice - Multiple Choice Papers Management
Version: 0.376
Release: 1%{?dist}
License: GPLv2+
Group: Productivity/Other
Source: auto-multiple-choice_0.376_precomp.tar.gz
%if 0%{?fedora}
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}
%else
BuildRoot: %{_tmppath}/%{name}-%{version}-build
%endif
URL: http://home.gna.org/auto-qcm/
Packager: Alexis Bienvenüe <pado@passoire.fr>
BuildRequires: gcc-c++, fontconfig-devel
%if 0%{?suse_version}
BuildRequires: update-desktop-files, libnetpbm-devel, libpoppler-devel >= 0.12.3, texlive
%endif
%if 0%{?fedora}
BuildRequires: desktop-file-utils, netpbm-devel, poppler-devel, texlive
%endif
%if 0%{?mandriva_version}
BuildRequires: desktop-file-utils, libnetpbm-devel, libpoppler-devel
%endif

Requires: perl >= 5.8, ghostscript
%if 0%{?mandriva_version}
Requires: poppler, graphicsmagick, imagemagick, texlive-texmf-cmsuper
%else
Requires: /usr/bin/pdftoppm, GraphicsMagick, ImageMagick
%endif

%if 0%{?suse_version}
Requires: poppler >= 0.12.3, poppler-tools >= 0.12.3
Requires: texlive, texlive-bin-latex, texlive-latex
Requires: perl(Archive::Tar), perl(Data::Dumper), perl(Encode), perl(Exporter), perl(Fcntl), perl(File::Copy), perl(File::Path), perl(File::Spec), perl(File::Spec::Functions), perl(File::Temp), perl(Getopt::Long), perl(Graphics::Magick), perl(Gtk2), perl(Gtk2::GladeXML), perl(I18N::Langinfo), perl(IO::File), perl(IO::Select), perl(IPC::Open2), perl(Locale::gettext), perl(Module::Load), perl(Module::Load::Conditional), perl(POSIX), perl(Storable), perl(Unicode::Normalize), perl(Time::Local), perl(XML::Simple), perl(XML::Writer), perl(constant), perl(encoding)
%endif
%if 0%{?fedora}
Requires: texlive-latex, texlive-texmf-latex, perl(Net::CUPS), perl(Net::CUPS::PPD)
%endif
%if 0%{?mandriva_version}
Requires: texlive, texlive-latex, perl(Net::CUPS), perl(Net::CUPS::PPD)
%endif

%if 0%{?mandriva_version}
Requires(post): tetex
Requires(postun): tetex
%else
Requires(post): texlive
Requires(postun): texlive
%endif

%{?perl_default_filter}

%description
Utility to manage multiple choice questionnaires, with optionnaly
mixed questions and answers. AMC provides automatic marking from papers'
scans. Annotated papers are produced. Marks can be exported as a
OpenOffice.org sheet file.

#'

%prep
%setup

%if 0%{?fedora}
# filter out package Perl modules, and optional OpenOffice::OODoc module.

cat << \EOF > %{name}-req
#!/bin/sh
%{__perl_requires} $* |\
sed -e '/perl(OpenOffice::OODoc)/d' -e '/perl(AMC::.*)/d'
EOF

%global __perl_requires %{_builddir}/%{name}-%{version}/%{name}-req
chmod +x %{__perl_requires}

%endif


%build

make %{AMC_makepass} GCC_NETPBM="-I /usr/include/netpbm -lnetpbm" GCC_POPPLER="-I /usr/include/poppler -lpoppler -I /usr/include/fontconfig -lfontconfig" GCC="gcc" GCC_PP="g++" CFLAGS="$RPM_OPT_FLAGS -Wall" CXXFLAGS="$RPM_OPT_FLAGS -Wall"

%install
make DESTDIR=$RPM_BUILD_ROOT %{AMC_makepass} install

%if 0%{?fedora:1}%{?mandriva_version:1}
desktop-file-install --delete-original --dir=%{buildroot}%{_datadir}/applications auto-multiple-choice.desktop
%endif

%if 0%{?suse_version}
%suse_update_desktop_file -i %{name}
%endif

%find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-,root,root,-)

%doc COPYING ChangeLog doc/html doc/auto-multiple-choice.??.xml doc/auto-multiple-choice.??.pdf 
%dir /usr/share/auto-multiple-choice
%dir /usr/share/texmf
%dir /usr/share/texmf/tex
%dir /usr/share/texmf/tex/latex
%{AMC_modsdir}
%{AMC_modelsdir}
%{AMC_iconsdir}
%{AMC_texdir}
%{AMC_bindir}/auto-multiple-choice
%{AMC_pixdir}/auto-multiple-choice.xpm
%{AMC_perldir}/AMC
%{_datadir}/applications/auto-multiple-choice.desktop
%{AMC_man1dir}/auto-multiple-choice.*.1*
%{AMC_man1dir}/auto-multiple-choice.1*

%post

%if 0%{?fedora}
texhash
%endif
%if 0%{?suse_version}
texconfig-sys rehash
%endif
%if 0%{?mandriva_version}
texconfig-sys rehash
%endif

%postun

%if 0%{?fedora}
texhash
%endif
%if 0%{?suse_version}
texconfig-sys rehash
%endif
%if 0%{?mandriva_version}
texhash
%endif

%changelog

* Tue Jan 11 2011 Alexis Bienvenue <pado@passoire.fr> 0.376-1

  - auto spec file for Fedora and SUSE. See ChangeLog for information.
