# library paths for libparted
# written by Damien Genet <damien.genet@free.fr>

dnl Usage:
dnl AM_PATH_PARTED([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl where MINIMUM-VERSION must be >= 1.2.8 and != 1.3.0
dnl
dnl Example:
dnl AM_PATH_PARTED(1.2.8, , AC_MSG_ERROR([*** libparted >= 1.2.8 not installed - please install first ***]))
dnl
dnl Add -lparted to @PARTED_LIBS@ 
dnl


AC_DEFUN(AM_PATH_PARTED,
[

dnl save LIBS
saved_LIBS="$LIBS"

dnl Check for headers and library
AC_CHECK_HEADER(parted/parted.h,,
            AC_MSG_ERROR([*** libparted headers not found - please install libparted ***])
            $3)
AC_HAVE_LIBRARY(parted,,
                AC_MSG_ERROR([*** libparted not found - please install libparted ***])
                $3)

AC_MSG_CHECKING(for libparted - version >= $1)

AC_TRY_LINK_FUNC(ped_get_version,,
                 AC_MSG_RESULT(failed)
                 AC_MSG_ERROR([*** libparted < 1.2.8 or == 1.3.0 can't execute test ***]))

dnl Get major, minor, and micro version from arg MINIMUM-VERSION
parted_config_major_version=`echo $1 | \
    sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
parted_config_minor_version=`echo $1 | \
    sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
parted_config_micro_version=`echo $1 | \
    sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

dnl Compare MINIMUM-VERSION with libparted version
AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <parted/parted.h>

int main ()
{
	int		major, minor, micro;
	const char	*version;    
	
	if ( !(version = ped_get_version ()) )
		exit(1);
	if (sscanf(version, "%d.%d.%d", &major, &minor, &micro) != 3) {
		printf("%s, bad version string\n", version);
		exit(1);
	}
	
	if ((major >= $parted_config_major_version) ||
	   ((major == $parted_config_major_version) && (minor >= $parted_config_minor_version)) ||
	   ((major == $parted_config_major_version) && (minor == $parted_config_minor_version) && (micro >= $parted_config_micro_version))) {
		return 0;
	} else {
		printf("\n*** An old version of libparted (%s) was found.\n",
		       version);
		printf("*** You need a version of libparted newer than %d.%d.%d.\n",
			$parted_config_major_version, 
			$parted_config_minor_version,
			$parted_config_micro_version);
		printf("*** You can get it at - ftp://ftp.gnu.org/gnu/parted/\n");
		return 1;
	}
}
], 
    AC_MSG_RESULT(yes),
    AC_MSG_RESULT(no) ; $3,
    [echo $ac_n "cross compiling; assumed OK... $ac_c"])

dnl restore orignial LIBS and set @PARTED_LIBS@
LIBS="$saved_LIBS"
PARTED_LIBS="-lparted"
AC_SUBST(PARTED_LIBS)

dnl Execute ACTION-IF-FOUND
$2

])
