# Autoinstaller boot setup code for setting up PALO.

# Written by Paul Telford

import string
import os

def runcmd(cmd):
    cmdresult = os.system(cmd)
    if cmdresult != 0:
        raise RuntimeError, "Error in executing %s, exit status %d" % (cmd, cmdresult)

def setup_boot_loader(stanzas):


    palo_conf = open("/target/etc/palo.conf", "w")
    rootdrv = stanzas[0]["rootdev"]
    bootdrv = stanzas[0]["bootdev"]
    kernel = stanzas[0]["kernel"]
    rootdev = rootdrv[:-1]
    rootdisk = rootdrv[-1]
    bootdisk = bootdrv[-1]
    palo_conf.write("""--commandline=%s/%s HOME=/ TERM=linux root=%s
--init-partitioned=%s
""" % (bootdisk, kernel, rootdrv, rootdev))
    palo_conf.close()
    runcmd("chroot /target /sbin/palo")

