#!/bin/sh

TMP=/tmp
#MONO=./monoopt.sh
MONO=$(which mono)

# Set this to the directory you installed autopano-sift into, for example
#AUTOPANO_PATH=/usr/local/autopano-sift/bin
# Do not use a trailing backslash. If the executeables are within your path
# (recommended, you can leave the line below).
AUTOPANO_PATH=$(dirname $(which generatekeys.exe))

if [ $# -lt 3 ]; then
	echo "usage: autopano-complete.sh output.pto image1 image2 [...]"
	exit 1
fi

#rm -f *.xml.gz
PANOFILE=$1
shift 1
for image in $@ ; do
	$MONO $AUTOPANO_PATH/generatekeys.exe $image \
		$(echo -n $image | sed -r 's@.+/([^/]+$)@\1@').key.gz 900
done

$MONO $AUTOPANO_PATH/autopano.exe $PANOFILE *.key.gz

