
using System;


public class FMMTest
{
	public static void Main (string[] args)
	{
		FMMTest test = new FMMTest ();

		/* First test the min heap
		 */
		//test.TestHeap ();
		test.TestFMM ();
	}

	/*** TESTING FMM
	 */
	private void TestFMM ()
	{
		FMM fmm = new FMM (128, 96);

		fmm.AddKnown (64, 48, 0.0, 1);
		fmm.AddKnown (84, 36, 0.0, 2);
		fmm.AddKnown (14, 36, 0.0, 3);
		fmm.AddKnown (24, 48, 0.0, 4);
		fmm.InitializeBand ();
		//Console.WriteLine (fmm);
		//return;

		/* Completely march the field.
		 */
		fmm.DoIterations (0, 0.0);

		Console.WriteLine ("Total sum: {0}", fmm.CalculateTotalSum ());
		for (int y = 0 ; y < fmm.ydim ; ++y) {
			for (int x = 0 ; x < fmm.xdim ; ++x) {
				//Console.WriteLine ("{0} {1} {2}", y, x, fmm.TMap[y, x]);
				Console.WriteLine ("{0} {1} {2} # CAUSE", y, x, fmm.CauseMap[y, x]);
			}
			Console.WriteLine ();
		}
	}


	/*** TESTING HEAP
	 */
	public void NotifyPositionTest (int idx, object val)
	{
		Console.WriteLine ("NotifyPositionTest ({0}, {1})",
			idx, (double) val);
	}

	private void TestHeap ()
	{
		FMM.MinHeap minheap = new FMM.MinHeap (16, this.NotifyPositionTest);

		/* Insert 200 quasi-random elements.
		 */
		for (double n = 0.0 ; n < 200.0 ; n += 1.0)
			minheap.Insert (Math.Sin (n), Math.Sin (n));

		int count = 0;
		while (minheap.IsEmpty == false) {
			object o1;
			double v1;

			o1 = minheap.DeleteMin (out v1);
			Console.WriteLine ("Element: value = {0}, object = {1}",
				v1, (double) o1);
			count += 1;
		}

		Console.WriteLine ();
		Console.WriteLine ("Got {0} elements.", count);
	}
}


