/*--------------------------------------------------------------------------*
 * AUTOPROFILE                                                              *
 *                                                                          *
 * A Gaim away message and profile manager that supports dynamic text       *
 *                                                                          *
 * AutoProfile is the legal property of its developers.  Please refer to    *
 * the COPYRIGHT file distributed with this source distribution.            *
 *                                                                          *
 * This program is free software; you can redistribute it and/or modify     *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation; either version 2 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA *
 *--------------------------------------------------------------------------*/

#include "component.h"

/*---------- TIMESTAMP: Display time at creation --*/
char *timestamp_generate () {
  struct tm *cur_time;
  char *ret;

  time_t *general_time = (time_t *)malloc(sizeof(time_t));
  time (general_time);
  cur_time = localtime (general_time);
  free (general_time);

  ret = (char *)malloc (1024);
  *ret = '\0';
  
  strftime (ret, 1023, 
    gaim_prefs_get_string ("/plugins/gtk/autoprofile/components/timestamp"),
    cur_time);

  return ret;
}

void timestamp_init () {
  gaim_prefs_add_string ("/plugins/gtk/autoprofile/components/timestamp",
    "Automatically created at %I:%M %p");
}

static gboolean timestamp_update (GtkWidget *widget, GdkEventFocus *evt,
                                  gpointer data)
{
  gaim_prefs_set_string (
    "/plugins/gtk/autoprofile/components/timestamp",
    gtk_entry_get_text (GTK_ENTRY (widget)));
  return FALSE;
}

GtkWidget *timestamp_menu ()
{
  GtkWidget *ret = gtk_vbox_new (FALSE, 5);
  GtkWidget *label, *entry, *sw;
  
  entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (ret), entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (entry), 1000);
  gtk_entry_set_text (GTK_ENTRY (entry), gaim_prefs_get_string (
    "/plugins/gtk/autoprofile/components/timestamp"));
  g_signal_connect (G_OBJECT (entry), "focus-out-event",
                    G_CALLBACK (timestamp_update), NULL);

  label = gtk_label_new (_(
    "Insert the following characters where time is to be displayed:\n\n%H\thour (24-hour clock)\n%I\thour (12-hour clock)\n%p\tAM or PM\n%M\tminute\n%S\tsecond\n%a\tabbreviated weekday name\n%A\tfull weekday name\n%b\tabbreviated month name\n%B\tfull month name\n%m\tmonth (numerical)\n%d\tday of the month\n%j\tday of the year\n%W\tweek number of the year\n%w\tweekday (numerical)\n%y\tyear without century\n%Y\tyear with century\n%z\ttime zone name, if any\n%%\t%" ));
  sw = gtk_scrolled_window_new (NULL,NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
    GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  gtk_box_pack_start (GTK_BOX (ret), sw, TRUE, TRUE , 0);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(sw), label);

  return ret;
}

struct component timestamp =
{
  N_("Timestamp"),
  N_("Displays custom text showing when message was created"),
  's',
  &timestamp_generate,
  &timestamp_init,
  NULL,
  NULL,
  &timestamp_menu
};

