dnl Check for lrintf presence
dnl currently needed only by ffmpeg
AC_DEFUN(AC_FUNC_LRINTF,
[
    AC_CACHE_CHECK([whether system declares lrintf function in math.h],
		   ac_cv_val_HAVE_LRINTF,
		   [ac_save_CFLAGS=$CFLAGS
                   CFLAGS="$CFLAGS -O2"
                   AC_TRY_RUN([
		    #define _ISOC9X_SOURCE  1
		    #include <math.h>
		    int main( void ) { return (lrintf(3.999f) > 0)?0:1; } ],
		   [ ac_cv_val_HAVE_LRINTF=yes ], [ ac_cv_val_HAVE_LRINTF=no ],
		   [ echo $ac_n "cross compiling; assumed OK... $ac_c" ])
                   CFLAGS=$ac_save_CFLAGS
		   ])
    if test x$ac_cv_val_HAVE_LRINTF = xyes; then
	AC_DEFINE(HAVE_LRINTF, 1, [Define if you have lrintf on your system.])
    fi
])


dnl Usage:
dnl AM_PATH_FFMPEG([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for ffmpeg, and define FFMPEG_CFLAGS and FFMPEG_LIBS

AC_DEFUN(AM_PATH_FFMPEG,
[
    AC_REQUIRE([AC_FUNC_LRINTF])

    dnl !!! - it really sucks - Makefile.am can't be optimized even by
    dnl !!! preparing some extra variable forward
    dnl !!! FFAVFORMAT_SRC=

    AC_REQUIRE([AC_CHECK_OSS])
    test x$enable_oss = xyes && AC_DEFINE(CONFIG_AUDIO_OSS, 1, [Define if you want to have ffmpeg OSS audio support compiled.])

    AC_REQUIRE([AC_CHECK_V4L])
    test x$enable_v4l = xyes && AC_DEFINE(CONFIG_VIDEO4LINUX, 1, [Define if you have video4linux device. (ffmpeg)])

    AC_REQUIRE([AC_FIND_ZLIB])
    test x$have_zlib = xyes && AC_DEFINE(CONFIG_ZLIB, 1, [Define if you have z library (-lz) (ffmpeg)])

    AC_ARG_ENABLE(ffmpeg_faadbin, [  --enable-ffmpeg-faadbin build ffmpeg with FAAD binary support. (default=yes)],
	          [], enable_ffmpeg_faadbin=yes)
    test x$enable_ffmpeg_faadbin = xyes && AC_DEFINE(CONFIG_FAADBIN, 1, [Define if you want to build support for runtime linked libfaad.])
    AC_REQUIRE([AM_PATH_FAAD])
    test x$have_faad = xyes && AC_DEFINE(CONFIG_FAAD, 1, [Define if you want to have AAC support compiled. (ffmpeg)])

    AC_ARG_ENABLE(ffmpeg_risky, [  --enable-ffmpeg-risky   build ffmpeg risky code. (default=yes)],
	          [], enable_ffmpeg_risky=yes)

    AC_ARG_ENABLE(ffmpeg_a52, [  --enable-ffmpeg-a52     build ffmpeg with A52 (AC3) support. (default=yes)],
		  [], enable_ffmpeg_a52=yes)
    if test x$enable_ffmpeg_a52 = xyes ; then
	AC_DEFINE(HAVE_FFMPEG_A52, 1, [Define if you want to use ffmpeg A52 audio decoder.])
	AC_ARG_ENABLE(ffmpeg_a52bin, [  --enable-ffmpeg-a52bin  A52 plugin dlopens liba52.so.0 at runtime (default=no)],
		      [], enable_ffmpeg_a52bin=no)
    fi

    test x$enable_ffmpeg_risky = xyes && AC_DEFINE(CONFIG_RISKY, 1, [Define if you want to compile patent encumbered codecs. (ffmpeg)])

    AC_DEFINE(CONFIG_ENCODERS, 1, [Define if you want to build ffmpeg encoders.])
    AC_DEFINE(CONFIG_DECODERS, 1, [Define if you want to build ffmpeg decoders.])
    AC_DEFINE(CONFIG_AC3, 1, [Define if you want to build ffmpeg with AC3 decoder.])
dnl    AC_DEFINE(CONFIG_A52BIN, 1, [Define if you want to build ffmpeg with A52 dlopened decoder.])
    AC_DEFINE(SIMPLE_IDCT, 1, [Define if you want to build ffmpeg with simples idct.])
    AC_DEFINE(CONFIG_NETWORK, 1, [Define if you want to build ffmpeg with network support.])
    AC_DEFINE(CONFIG_MPEGAUDIO_HP, 1, [Define if you want to have highquality ffmpeg mpeg audio support compiled.])

    if test -n "$ffmpeg_profiling" ; then
	AC_DEFINE(HAVE_GPROF, 1, [Define if you want to build ffmpeg with gprof support.])
    fi

    AM_CONDITIONAL(AMM_BUILD_STRPTIME, test x$ac_cv_func_strptime != xyes )

dnl ffmpeg_x86opt=
dnl test x$enable_x86opt = xno && ffmpeg_x86opt="--disable-mmx"
dnl AC_MSG_RESULT([=== configuring ffmpeg ===])
dnl    ( cd $srcdir/ffmpeg ; \
dnl      ./configure --prefix=$prefix --cc=$CC \
dnl		$ffmpeg_profiling $ffmpeg_cpu \
dnl		$ffmpeg_x86opt --disable-mp3lib \
dnl		--enable-simple_idct )
])
