/*************************************************************************
 * avinfo.h basic defenition for AVInfo [part of AVInfo 1.x]
 *
 * Copyright (c) 2003 George Shuklin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307  USA  or visit http://www.gnu.org/copyleft/gpl.html
 *
 *************************************************************************/
#ifndef _H_AVINFO_H
#define _H_AVINFO_H

enum video_enum{
	V_l,
	V_x,
	V_y,
	V_bits,
	V_cc,
	V_fpsH,
	V_fpsL,
	V_bps,
	V_vbr_flag,
	V_aspectX,
	V_aspectY,
	V_exist
}video_enum;

#define VIDEO_INFO_SIZE (V_exist+1)

enum{
	A_l,
	A_bits,
	A_cc,
	A_bps,
	A_vbr_flag,
	A_ch,
	A_freq,
	A_exist
}audio_enum;


#define AUDIO_INFO_SIZE (A_exist+1)

#define MAX_STREAMS 9

#include "ver.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "var.h"
#include "common.h"
#include "print.h"
#include "config.h"
#include "wintypes.h"
#include "riff.h"
#include "mpeg.h"
#include "text.h"
#include "ifo.h"
#include "ogm.h"
#include "mkv.h"
#include "codec.h"
#include "ass.h"
/*#include "cache.h"*/

/*#define CASE_SENSETIVE*/
/*Use define CASE_SENSETIVE to set a case sensetive text parsing. if CASE_SENSETIVE not defined var names and keywords will be case unsensetive.*/

#ifdef CASE_SENSITIVE
	#define STRCMP strcmp
#endif

#ifndef CASE_SENSITIVE
	#define STRCMP STRICMP
#endif


#ifndef MAX_PATH 
	#define MAX_PATH 32767
#endif



typedef int (*modulefunc) (FILE* file, int flags ); 


typedef struct{
	char* mask; /*mask of supported files*/
	int ver;
	modulefunc func;
}module_t;

extern const module_t modules[];

#define FREE(a){free(a);a=NULL;}
/*safe ver. of free();*/

#endif
