/*  -*- Mode: Asm -*-  */

/* Copyright (c) 2002  Michael Stumpf  <mistumpf@de.pepperl-fuchs.com>
   All rights reserved.


   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
     
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. 
*/

/* $Id: sin.S,v 1.7 2005/09/13 13:29:54 joerg_wunsch Exp $ */

/*
    sin.S is part of     FPlib V 0.3.0       ported to avr-as
    for details see readme.fplib

 *----------------------------------------------------------------------------------------
 *
 *	A = sin(A) = cos(A-PI/2)
 */

#if !defined(__DOXYGEN__)

#include "gasava.inc"
#include "macros.inc"
#include "fplib.inc"

          TEXT_SEG(fplib, sin)
          FUNCTION(sin)

GLOBAL(sin)
       PUSH   rA3
       ANDI   rA3,0x7F
       CPI    rA3,0x39
       BRCS   1f		; |A| < 0x38FFFFFF -> sin(A) = A

       LDI    rB3,0x40
       LDI    rB2,0xC9
       LDI    rB1,0x0F
       LDI    rB0,0xDB		; load 2*PI
       RCALL  _U(fmod)		; X = remainder X/2PI

       LDI    rB3,0xBF
       LDI    rB2,0xC9
       LDI    rB1,0x0F
       LDI    rB0,0xDB		; load -PI/2
       RCALL  _U(__addsf3)	; A - PI/2
       RCALL  _U(__fp_cosinus)
1:
       POP    rB3
       ANDI   rB3,0x80
       EOR    rA3,rB3		; invert sign, if
       RET

          ENDFUNC

#endif /* not __DOXYGEN__ */
