#ifndef CONFIG_H
#define CONFIG_H


/*
 *	Languages (define only one):
 */
#define PROG_LANGUAGE_ENGLISH		1
/* #define PROG_LANGUAGE_SPANISH	2 */
/* #define PROG_LANGUAGE_FRENCH		3 */
/* *incomplete* #define PROG_LANGUAGE_GERMAN	4 */
/* *incomplete* #define PROG_LANGUAGE_ITALIAN	5 */
/* *incomplete* #define PROG_LANGUAGE_DUTCH	6 */
/* *incomplete* #define PROG_LANGUAGE_NORWEGIAN	7 */
/* *incomplete* #define PROG_LANGUAGE_PORTUGUESE	8 */


/*
 *      Program name and version:
 */
#define PROG_NAME		"AVScan"
#define PROG_NAME_FULL		"AntiVirus Scanner"

#define PROG_VERSION		"3.2.1"

#define PROG_VERSION_MAJOR	3
#define PROG_VERSION_MINOR	2
#define PROG_VERSION_RELEASE	1

/*
 *	Program URL:
 */
#define PROG_URL	"http://wolfpack.twu.net/Endeavour2/"

/*
 *      Copyright message:
 */
#if defined(PROG_LANGUAGE_SPANISH)
#define PROG_COPYRIGHT	"\
El derecho de autor (C) 1997-2007 WolfPack Entertainment.\n\
Este programa es protegido por leyes internacionales de derecho de autor\n\
y tratados, la distribucin y/o la modificacin de este software en la\n\
infraccin de la Licencia del Pblico de GNU se prohiben estrictamente.\n\
Violators ser procesado a la extensin ms repleta de la ley.\n"
#elif defined(PROG_LANGUAGE_FRENCH)
#define PROG_COPYRIGHT  "\
Dposer (C) 1997-2007 WolfPack Entertainment.\n\
Ce programme est protg par international dpose lois et traits, \n\
distribution et/ou de ce logiciel dans violation du GNU Public Permis\n\
strictement est interdit. Violators sera poursuivi  l'tendue plus pleine\n\
de la loi.\n"
#elif defined(PROG_LANGUAGE_GERMAN)
#define PROG_COPYRIGHT  "\
Urheberrecht (C) 1997-2007 WolfPack Entertainment.\n\
Dieses Programm wird von internationalem Urheberrecht Gesetzen und\n\
Vertrgen, Austeilung bzw. nderung dieser Software in bertretung\n\
DER GNU ffentlichkeit Erlaubnis streng verboten wird geschtzt.\n\
Verletzer werden zum vollsten Umfang des Gesetzes strafrechtlich\n\
verfolgt werden.\n"
#elif defined(PROG_LANGUAGE_ITALIAN)
#define PROG_COPYRIGHT  "\
Il copyright (C) 1997-2007 WolfPack Entertainment.\n\
Questo programma  protetto dalle leggi di copyright internazionali e\n\
dai trattati, la distribuzione e/o la modifica di questo software nella\n\
violazione dello GNU la Licenza Pubblica  strettamente proibita. Il\n\
Violators sar perseguito all'estensione la pi piena della legge.\n"
#elif defined(PROG_LANGUAGE_DUTCH)
#define PROG_COPYRIGHT  "\
Auteursrecht (C) 1997-2007 WolfPack Entertainment.\n\
Deze programma wordt door internationale auteursrecht wetten en\n\
verdragen, verdeling en/of wijziging van deze software in overtreding\n\
van de GNU Publiek Vergunning strikt verboden wordt beschermd.\n\
Overtreders zullen te de volste omvang van de wet geprocedeerd worden.\n"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
#define PROG_COPYRIGHT  "\
Os direitos autorais (C) 1997-2007 WolfPack Entertainment.\n\
Este programa  protegido por direitos internacionais leis autorais e\n\
tratados, modificao de e/ou de distribuio deste software em infrao\n\
do GNU Licena Pblica precisamente  proibida. O Violators ser\n\
processado  plena extenso da lei.\n"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2007 WolfPack Entertainment.\n\
Dette programet beskytter av internasjonal copyrightlover og traktater,\n\
distribusjon og/eller modifikasjon av denne programvaren i overtredelse\n\
av GNU Public License er streng forbudt. Violators tiltalt til den\n\
fulleste omfang av loven.\n"
#else
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2007 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosecuted\n\
to the fullest extent of the law.\n"
#endif


/*
 *	Prefix Directory:
 */
#ifndef PREFIX
# define PREFIX		"/usr"
#endif


/*
 *	Usage message:
 */
#define PROG_USAGE_MESG  "\
Usage: avscan <path(s)...> [options]\n\
       avscan --scan <path(s)...> [options]\n\
\n\
    The <path(s)...> specifies the full paths to the file(s) and/or\n\
    directory(ies) to scan at startup.\n\
\n\
    The [options] can be any of the following:\n\
\n\
        --recursive             Recurse into subdirectories.\n\
        -r                      Same as --recursive.\n\
        --executables-only      Scan executable files only.\n\
        -x                      Same as --executables-only.\n\
	--ignore-links		Do not scan link destinations.\n\
	-l			Same as --ignore-links.\n\
        --database <path>       Set the virus database to <path> (this\n\
                                may be a file or directory).\n\
        -db <path>              Same as --database.\n\
\n\
        --cpu-priority <priority>  Sets the CPU priority, valid values\n\
                                are; highest, high, medium, low,\n\
                                lowest.\n\
\n\
        --report-all-objects    Specifies to report all objects that\n\
                                have been scanned to the Results List.\n\
        --no-report-all-objects Specifies to only report objects that\n\
                                are infected or have problems to the\n\
                                Results List (opposite of\n\
                                --report-all-objects).\n\
\n\
        --max-files <n>         Sets the maximum number of files in an\n\
                                archive to scan.\n\
        --max-file-size <n>     Sets the maximum size of a file in an\n\
                                archive to scan.\n\
        --max-recursions <n>    Sets the maximum archive recursions.\n\
        --max-mail-recursions <n>  Sets the maximum mail recursions.\n\
        --max-compression-ratio <n>  Set the maximum archive\n\
                                compression ratio to scan.\n\
\n\
        --help                  Prints this help screen and exits.\n\
        --version               Prints the version information and exits.\n\
\n\
    Return values:\n\
\n\
        0       Success.\n\
        1       Virus detected or general error.\n\
        2       Invalid value.\n\
        3       Systems error or memory allocation error.\n\
        4       User aborted (otherwise no other error).\n\
        5       User responded with \"no\" to a query (otherwise\n\
                no other error).\n\
        6       An identical operation is already in progress.\n\
        7       Reserved.
        8       Segmentation fault.\n\
\n\
        50      Unable to load or initialize the virus database.\n\
        51      An input file has a corrupt format or a format not\n\
                consistent with its extension.\n\
        52      Unsupported object type.\n\
        53      Unable to open an input directory.\n\
        54      Unable to open an input file.\n\
        55      An error occured while reading an input file.\n\
        56      Unable to stat() or lstat() an input file.\n\
        57      Scan of object was incomplete because it would\n\
                otherwise exceed a specified limit.\n\
        58      Reserved.\n\
        59      Scanner subsystem or plugin unable to scan an input\n\
                file.\n\
	60	Unsupported file format.\n\
	61	Unable to lock the virus database directory.\n\
\n\
        99      No virus scanner support compiled.\n\
\n"


/*
 *	Configuration File Characters:
 */
#define CFG_COMMENT_CHAR		'#'
#define CFG_DELIMINATOR_CHAR		'='


/*
 *	Environment Variable Names:
 */
#define ENV_VAR_NAME_BROWSER		"BROWSER"
#define ENV_VAR_NAME_HELPBROWSER	"HELPBROWSER"
#define ENV_VAR_NAME_TMPDIR		"TMPDIR"


/*
 *	Widget Names:
 */
#define AVSCAN_SCANNER_TOPLEVEL_WIDGET_NAME	"avscan-scanner"
#define AVSCAN_SCANNER_SCAN_CLIST_WIDGET_NAME	"avscan-scanner-scan-clist"
#define AVSCAN_SCANNER_RESULTS_CLIST_WIDGET_NAME	"avscan-scanner-results-clist"
#define AVSCAN_SCANNER_DB_CTREE_WIDGET_NAME	"avscan-scanner-db-ctree" 


/*
 *	DND Infos:
 */
#define DND_INFO_TEXT_PLAIN		0	/* "text/plain" */
#define DND_INFO_TEXT_URI_LIST		1	/* "text/uri-list" */
#define DND_INFO_STRING			2	/* "STRING" */

#define AVSCAN_DND_INFO_SCAN_ITEM		3	/* AVScan/ScanItem */
#define AVSCAN_DND_TARGET_SCAN_ITEM		"AVScan/ScanItem"


/*
 *	List Defaults:
 */
#define WIN_LIST_ROW_SPACING		20	/* In pixels */
#define WIN_LIST_PIXMAP_TEXT_SPACING	2	/* In pixels */


/*
 *	Configuration Files:
 */
#define AVSCAN_CFG_FILE			"avscan.ini"
#define AVSCAN_SCAN_LIST_FILE		"avscan_scan_list.ini"
#define AVSCAN_LAST_SCAN_RESULTS_LOG_FILE	"avscan.log"
#if defined(DEBIAN)
# define AVSCAN_DB_LOCATION		"/var/lib/clamav"
#else
# define AVSCAN_DB_LOCATION		PREFIX "/share/clamav"
#endif


#endif	/* CONFIG_H */
