/*
 *  ax25spyd - An AX.25 monitorspy daemon
 *
 *  Copyright (C) 1999 Free Software Foundation, Inc.
 *  Copyright (C) 1999 Walter Koch, dg9ep
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: mheard.c,v 1.25 1999/07/13 22:26:11 walter Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <syslog.h>

#include "monixd.h"


struct t_mheard mheard;
struct t_CallMheard *pCallMheardRoot;
/* struct t_QSOMheard  *pQSOMheardRoot; */
struct t_qso  *pQSOMheardRoot;
static int idGlobalCounter = 1;

/*----------------------------------------------------------------------*/

void
mheard_init(void)
{
    pCallMheardRoot = NULL;
    pQSOMheardRoot = NULL;

    memset(&mheard, 0, sizeof(mheard));
    mheard.version = sizeof(mheard);
    time(&mheard.starttime);
}


/*-----------global mheard/Dxcluster----------------------------------------*/

void
sendMHeard(int iClient)
{
    lwrite(iClient, T_MHEARDSTRUCT, &mheard, sizeof(mheard) );
}

int
hashitkanon(unsigned char *data, int length)
{
    int i, res;
    res = 0xa55a;
    for(i=0;i<length;i++,data++) {
	if( isalnum(*data) ) {
	    res = res ^ tolower(*data) ;
	    /* rotate it */
	    res = (res << 1) | ((res >> (sizeof(int)*8-1)) & 1) ;
	}
    }
    return res+1;
}

void
tryspydxcluster(struct t_ax25packet* pax25)
{
#define nLASTDX 80
    static int lastDX[nLASTDX];
    static int iDX = 0;
    int hash, i;
    unsigned char* data = pax25->pdata;
    int length		= pax25->datalength;

    if( length < 5 )
	return;
    if( pax25->pid != PID_TEXT )
	return;

    /* if( fVerbose ) */
	/* syslog(LOG_debug,""trydx %c%c%c%c\n"", data[0],data[1],data[2],data[3] ); */
    if( memcmp(data,"DX de ",6) == 0 ) {
	/* checks for doubles */
	hash = hashitkanon(data, length);
/*	  if( fVerbose )
 -	      syslog(LOG_DEBUG," hash: %d\n", hash );
 */
	for(i=0;i<nLASTDX;i++)
	    if( hash==lastDX[i] )
	       return; /* already displayed */
	lastDX[iDX++] = hash;
	if( iDX >= nLASTDX )
	    iDX = 0;
	/* if( fVerbose ) */
	    /* syslog(LOG_debug,""  write dx\n"" ); */
	lwriteAll(T_DXCLUST,data,length);
	mheard.nDXClust++;
    }
#undef nLASTDX
}

void
tryspyHeader( struct t_ax25packet* pax25, char *sFmCallFilter , char *sToCallFilter )
{
/*    if( sFmCallFilter != NULL )
 *	  if( strcmp(pax25->fmcall.sCall,sFmCallFilter) != 0 )
 *	      return;
 *    if( sToCallFilter != NULL )
 *	  if( strcmp(pax25->tocall.sCall,sToCallFilter) != 0 )
 *	      return;
 *
 *    lwriteAll(T_DXCLUST, pax25->pdata, pax25->datalength );
 */
}

/*-----------call mheard-----------------------------------------------*/

void
sendCallMHeard(int iClient, char *sFilter)
{
    struct t_CallMheard* p;

    if( sFilter == NULL ) {
	for( p = pCallMheardRoot; p != NULL; p = p->pNext ) {
	    lwrite( iClient, T_CALLMHEARDSTRUCT, p, sizeof(struct t_CallMheard) );
	}
    } else {
	for( p = pCallMheardRoot; p != NULL; p = p->pNext ) {
	    if( strstr(p->call.sCall,sFilter)!=NULL )
		lwrite( iClient, T_CALLMHEARDSTRUCT, p, sizeof(struct t_CallMheard) );
	}
    }
    /* if( (sFilter == NULL) || (strstr(p->call.sCall,sFilter)!=NULL) )  */
    lwrite(iClient, T_ENDOFDATA, '\0' , 0 );
}


static struct t_CallMheard*
searchCallMheardCall(struct t_ax25call *pcall)
{
    struct t_CallMheard* p;

    for( p = pCallMheardRoot; p != NULL; p = p->pNext )
	if( !memcmp( pcall, &p->call, sizeof(struct t_ax25call) ) )
	    return p;
    return NULL;
}


static struct t_CallMheard*
getCallMheardCall(struct t_ax25call *pcall, struct t_ax25packet *pax25)
{
    struct t_CallMheard *pres;
    /* first, look for existing calls */
    if( (pres = searchCallMheardCall(pcall)) != NULL ) {
	/* found, return it */
	return pres;
    }
    /* not found, generate new entry */
    pres = malloc( sizeof(struct t_CallMheard) );
    memset( pres, 0, sizeof(struct t_CallMheard) );

    pres->version = sizeof(struct t_CallMheard);
    pres->firstheard = pax25->time;
    memcpy( &pres->call, pcall, sizeof(struct t_ax25call) );
    if( fVerbose )
	syslog(LOG_INFO,"new call heard: %s\n", ax25call2str( &pres->call) );
    /* put it into the front */
    pres->pNext = pCallMheardRoot;
    pCallMheardRoot = pres;

    return pres;
}

static void
doCallMheardCall(struct t_ax25call *pCall, struct t_ax25packet *pax25)
/*  do the callstatistic for *pCall according to data in packet *pac25.
 *  if fDirectHeard is true, *pCall was heard directly */
{
    struct t_CallMheard *pCallMheard;

    if( (pCallMheard = getCallMheardCall( pCall, pax25 )) == NULL )
	return;
    pCallMheard->lastheard = pax25->time;
    pCallMheard->nTotalBytes += pax25->totlength;
    pCallMheard->nFrames++;
    pCallMheard->nDirectFrames++;
    pCallMheard->frametype[ frametype2ord(pax25->frametype) ]++;
    if( pax25->pid >= 0 ) {
	pCallMheard->nInfoBytes += pax25->datalength;
	pCallMheard->nPID[pax25->pid]++;
    }
}


void
doCallMheard(struct t_ax25packet* pax25)
/* add or update the callMheard-List from pax25  */
{
    int i;

    if( (i=pax25->ndigirepeated) == -1 )
	doCallMheardCall( &pax25->fmcall, pax25 );
    else
	doCallMheardCall( &pax25->digi[i], pax25 );
}

/*-----------qso mheard-----------------------------------------------*/


void
qsoclientIndexDeleted( int iClient)
{
    struct t_qso *p;

    for( p = pQSOMheardRoot; p != NULL; p = p->pNext ) {
	  p->spyclient[iClient] = 0;
    }
}

void
qsoclientIndexChanged( int oldIndex, int newIndex)
{
    struct t_qso *p;

    for( p = pQSOMheardRoot; p != NULL; p = p->pNext ) {
	  if( p->spyclient[oldIndex] ) {
		p->spyclient[oldIndex] = 0;
		p->spyclient[newIndex] = 1;
	  }
    }
}


void
sendQSOMHeard(int iClient, char *sFilter)
{
    struct t_qso *p;

    if( sFilter == NULL ) {
	for( p = pQSOMheardRoot; p != NULL; p = p->pNext ) {
	    lwrite( iClient, T_QSOMHEARDSTRUCT, p, sizeof(*p) );
	}
    } else {
	for( p = pQSOMheardRoot; p != NULL; p = p->pNext ) {
	    if( (strstr(p->fmcall.sCall,sFilter)!=NULL)
	     || (strstr(p->tocall.sCall,sFilter)!=NULL) )
		lwrite( iClient, T_QSOMHEARDSTRUCT, p, sizeof(*p) );
	}
    }
    lwrite(iClient, T_ENDOFDATA, '\0' , 0 );
}


static struct t_qso*
searchQSOMheardCalls(struct t_ax25call *pfmcall, struct t_ax25call *ptocall)
{
    struct t_qso* p;

    for( p = pQSOMheardRoot; p != NULL; p = p->pNext )
	if(    !memcmp( pfmcall, &p->fmcall, sizeof(struct t_ax25call) )
	    && !memcmp( ptocall, &p->tocall, sizeof(struct t_ax25call) ) )
		return p; /* found */
    return NULL;
}

struct t_qso*
searchQSOFromQSOid( t_qsoid id )
{
    struct t_qso* p;

    for( p = pQSOMheardRoot; p != NULL; p = p->pNext )
	if( p->qsoid == id )
	     return p; /* found */
    return NULL;
}


static struct t_qso*
getQSOMheard(struct t_ax25packet* pax25)
/* search for the t_qso-entry for packet *pax25
 * If it does not exist, create it */
{
    struct t_qso *pQSO, *pvvQSO;

    /* first, look for existing QSOs */
    pQSO = searchQSOMheardCalls( &pax25->fmcall, &pax25->tocall );
    if( pQSO != NULL ) { /* found, return it */
	return pQSO;
    }

    /* not found, generate NEW entry */
    pQSO = malloc( sizeof( struct t_qso ) );
    memset( pQSO, 0, sizeof( struct t_qso ) );

    /* init some values */
    pQSO->version = sizeof(struct t_qso);
    pQSO->qsoid = idGlobalCounter++;
    pQSO->pid = -1;
    pQSO->lastSpyedNumber = -1;
    memcpy( &pQSO->fmcall, &pax25->fmcall, sizeof(struct t_ax25call) );
    memcpy( &pQSO->tocall, &pax25->tocall, sizeof(struct t_ax25call) );
    pQSO->firstheard = pQSO->lastheard = pax25->time;
    /* look for the vice-versa qso */
    pvvQSO = searchQSOMheardCalls( &pax25->tocall, &pax25->fmcall );
    if( pvvQSO != NULL ) { /* found it */
	pQSO->otherqsoid   = pvvQSO->qsoid;
	pvvQSO->otherqsoid = pQSO->qsoid;
	pQSO->pOtherqso    = pvvQSO;
	pvvQSO->pOtherqso  = pQSO;
    }
    /* put entry at the start of the chain */
    pQSO->pNext = pQSOMheardRoot;
    pQSOMheardRoot = pQSO;

    if( fVerbose ) {
	char buf1[80],buf2[80];
	syslog(LOG_INFO,"new QSO %d (%d): %s -> %s",
			 pQSO->qsoid, pQSO->otherqsoid,
			 ax25call2strBuf(&pQSO->fmcall,buf1),
			 ax25call2strBuf(&pQSO->tocall,buf2)
	);
    }

    return pQSO;
}

void
delQSO( struct t_qso *pQSO )
{
    struct t_qso *p, *pLast, *pOther;
    int i;

    /* do not use a search function, because we need the last-pointer */
    pLast = NULL;
    for( p = pQSOMheardRoot; p != NULL; p = p->pNext ) {
	if( p == pQSO ) {
	    char buf1[80],buf2[80];
	    /* found */
	    if( fVerbose )
		syslog(LOG_INFO,"removing QSO %d: %s -> %s", pQSO->qsoid,
				  ax25call2strBuf( &pQSO->fmcall, buf1 ),
				  ax25call2strBuf( &pQSO->tocall, buf2 )
		);
	    /* An alle Clients 'nen SPYEND senden */
	    for(i=0;i<nClient;i++)
		if( p->spyclient[i] )
		    lwrite( i, T_SPYEND, p, sizeof(*p) );
	    /* remove references */
	    pOther = NULL;
	    if( p->pOtherqso ) {
		/* Gegenrichtung auch morden */
		pOther = p->pOtherqso;
		p->pOtherqso->otherqsoid = 0;
		p->pOtherqso->pOtherqso  = NULL;
		p->otherqsoid		 = 0;
		p->pOtherqso		 = NULL;
	    }
	    if( p->pFirstPacket ) {
		 if( p->pFirstPacket->pdata );
		     free(p->pFirstPacket->pdata);
		 free(p->pFirstPacket);
		 p->pFirstPacket = NULL;
	    }
	    /* Aushngen */
	    if( pLast == NULL )
		pQSOMheardRoot = p->pNext;
	    else
		pLast->pNext = p->pNext;

	    free(pQSO);

	    if( pOther ) {
		/* must be last in block to avoid endless recursion
		 * and must be after (aushngen), otherwise the pLast
		 * could have became invalid ...*/
		delQSO(pOther);
	    }

	    return;
	}
	pLast = p;
    }
}


struct t_ax25packet*
ax25packetCopy( struct t_ax25packet *pax25 )
/* copy ax25packet, including the data part (kindof deepCopy :-) ) */
{
    struct t_ax25packet* pres;
    char *p;
    pres = malloc( sizeof(struct t_ax25packet) );
    memcpy( pres, pax25 , sizeof(struct t_ax25packet) );
    if( pax25->datalength > 0  ) {
	p = malloc( pax25->datalength );
	memcpy( p, pax25->pdata , pax25->datalength );
	pres->pdata = p;
    } else {
	pres->pdata = NULL;
    }
    return pres;
}


struct t_qso*
doQSOMheard(struct t_ax25packet* pax25)
/* add or update the QSOMheard-List from pax25	*/
{
    struct t_qso *pQSO;

    if( (pQSO = getQSOMheard( pax25 )) == NULL )
	return NULL; /* error */

    pQSO->lastheard = pax25->time;
    pQSO->nTotalBytes += pax25->totlength;
    pQSO->nFrames++;
    pQSO->frametype[ frametype2ord(pax25->frametype) ]++;
    if( (pQSO->pid == -1) && (pax25->pid >= 0) ) {
	/* First (U)I - frame for this QSO and pid is not
	 * set already (S-Frames got a pid==-1) */
	pQSO->pid = pax25->pid;
	pQSO->pFirstPacket = ax25packetCopy(pax25);
	if( fVerbose > 1 )
	    syslog(LOG_INFO, "try startSpyNewQso() for QSO %d ...",pQSO->qsoid);
	startSpyNewQSO( pQSO );
    }
    if( pQSO->pid >= 0 ) {
	pQSO->nInfoBytes += pax25->datalength;
    }
    return pQSO;
}

