/******************************************************************************
 *
 * tx_unix.c
 *
 * Unix variants of the OS-level utilities for testaldor.
 *
 *****************************************************************************/

#include "stat.h0"
#include "stdlib.h0"  /* for system() */

/******************************************************************************
 *
 * :: osRunOutput
 *
 *****************************************************************************/

#define OSFmtOutput	"%s > %s 2>&1"

/******************************************************************************
 *
 * :: osRunScript
 *
 *****************************************************************************/

#define OSFmtScript	"sh %s"

/******************************************************************************
 *
 * :: osShowDiff
 *
 *****************************************************************************/

#define OSFmtDiff	"diff %s %s"

/******************************************************************************
 *
 * :: osMakeDir
 *
 *****************************************************************************/

Int
osMakeDir(fn)
	String	fn;
{
	return mkdir(fn, S_IRWXU );
}

/******************************************************************************
 *
 * :: osRemoveDir
 *
 *****************************************************************************/

Int
osRemoveDir(fn)
	String	fn;
{
	return system(strPrintf("rm -rf %s", fn));
}

/******************************************************************************
 *
 * :: osFileCombine
 *
 *****************************************************************************/

#define		OS_PATH_SEP		"/"

/******************************************************************************
 *
 * :: osTempDirName
 *
 *****************************************************************************/

String
osTempDirName()
{
	return strPrintf("/tmp/testaldor.%d", osFnameTempSeed());
}
