#!/bin/bsh
#
# AXIOMXL BUG FILE DELIVERY
# ========================
#
# ** Bug files are accepted by mail at the account
#       infodesk@nag.co.uk
#    This account needs to have up-to-date "extnet" privledges to
#    receive bugs from non-IBM sites.
#
# ** These messages are forwarded to the local account
#       axlbugs@axiomxl.watson.ibm.com
#    This is set up using the command "xforward" on a Yorktown mainframe.
#
# ** The messages are forwarded to the bug file directory 
#       /axiomxl/bugs
#    by placing the following line in axiomxl:/u/axlbugs/.forward
# 	|/axiomxl/server/bugs/recvbug
#
# ** This causes the forwarded mail to be piped through this program,
#    which deposits a file in the directory $BugDir, updates the log file,
#    notifies the fixers, and replies to the sender.
#
# ** The true source of this program, recvbug.{c,sh}, is in the directory
#      /axiomxl/version/current/tools/unix.
#    The makefile in that directory should 
#    1. Copy    recvbug.sh to axiomxl:$BugDir/recvbug.sh
#    2. Compile recvbug.c  to axiomxl:$BugDir/recvbug   with suid spad.
#
# ** SMW October 92. 
#    Updated Apr 93.
#    Updated May 93 -- notify fixers.
#    Updated Jun 93 -- Ignore replies, include file in ack.
#    Updated Aug 93 -- make sender and subject prominent in notification.
#    Updated Oct 93 -- made BugDir axiomxl:/axiomxl/bugs
#    Updated Jun 94 -- Renamed recvbug. fixed machine names, Fixers, Maintainers


BugDir=/axiomxl/bugs

Maintainers="`cat $BugDir/Maintainers`"
Fixers="`cat $BugDir/Fixers`"

cd $BugDir

#
# Utilities
#
GetMessageSender() {
	# Arg 1 is the "From" pattern.
	# Arg 2 is the message file name.
	
	egrep -e "$1" "$2" | sed -e "s/$1//" | head -1 | awk '
	!/<.*>/	{ print $1 }
	/<.*>/	{
		  name = substr($0, index($0, "<")+1)
		  name = substr(name, 1, index(name, ">")-1)
		  print name
		}
'
}

GetMessageSubject() {
	# Arg 1 is the "Subject" pattern.
	# Arg 2 is the message file name.
	
	egrep -e "$1" "$2" | sed -e "s/$1//" | head -1 
}


#
# Step 0.  Capture message.  If it is from a daemon or is a reply, ignore it.
#
cat > /tmp/axlbug.$$

for who in DAEMON forward postmaster
do
	if egrep -i "^From:.*$who.*" /tmp/axlbug.$$
	then
		mail -s "Ignored daemon" $Maintainers < /tmp/axlbug.$$
		exit 0
	fi
done

Sender=`GetMessageSender "^From:" /tmp/axlbug.$$`
Subject=`GetMessageSubject "^Subject: " /tmp/axlbug.$$`

if egrep -i "^Subject:.*Received AXIOM-XL bug.*" /tmp/axlbug.$$
then
	mail -s "Sorry, this address cannot handle replies." \
		$Sender $Maintainers < /tmp/axlbug.$$
	exit 0
fi

if egrep -i "^Subject:.*AXIOM-XL fix notification.*" /tmp/axlbug.$$
then
	mail -s "Sorry, this address cannot handle replies." \
		$Sender $Maintainers < /tmp/axlbug.$$
	exit 0
fi


#
# Step 1.  Reserve a bug file number
#
BugNum=`cat recvbug.next`
expr $BugNum + 1 > recvbug.next
BugFile=bug"$BugNum"


#
# Step 2. Save message with mail header as comments and with a fix template.
#
awk < /tmp/axlbug.$$ '
BEGIN				{ seenblank = 0 }
seenblank == 1			{ print $0 }
(seenblank == 0) && !/^$/	{ print "--* " $0 }
(seenblank == 0) && /^$/	{
	print ""
	print "--@ Fixed  by: <Who> <Date>"
	print "--@ Tested by: <Name of new or existing file in test directory>"
	print "--@ Summary:   <Description of real problem and the fix>"
	print ""
	seenblank = 1
}
' > $BugFile.as

chmod a+r $BugFile.as


#
# Step 3. Formulate confirmation
#
cat > /tmp/ainfo.$$ <<EOF

  Reporter:    $Sender
  Number:      $BugFile
  Description: $Subject

Thank you for your bug report.  It has been assigned bug number $BugFile.

If you wish to discuss this bug via E-mail, please direct your messages
to specific people and include the bug number.

------------------------------ $BugFile.as ---------------------------------
EOF
cat $BugFile.as >> /tmp/ainfo.$$


#
# Step 4. Record bug in log
#
echo "$BugFile                : $Subject"  >> Log


#
# Step 5. Notify the sender and bug fixers that a bug has arrived
#
mail -s "Received AXIOM-XL $BugFile" $Fixers  "$Sender" < /tmp/ainfo.$$


#
# Step 6. Clean up
#
rm /tmp/axlbug.$$
rm /tmp/ainfo.$$
