##############################################################################
#
# VMS MMS description file (Makefile)
#
# Make program to build the Foam library for the AXIOM-XL compiler
#
##############################################################################
#
# Modifications for VMS MMS:
#
#    1. UNIX style file paths "foo/bar/bletch" changed to VMS style paths
#       "[foo.bar]bletch".
#    2. UNIX tools replaces by VMS equivalents: e.g., `ls' -> `DIRECTORY'.
#    3. The `:' separating targets from sources in dependency rules must
#	have spaces around it in MMS (to avoid ambiguity with the character's
#	use in VMS file specfication syntax).
#
##############################################################################
#
# Targets: all, junk, clean, quick
#
#    MMS all	-- make the basic library for the AXIOM-XL compiler
#    MMS junk	-- list files which are not part of the AXIOM-XL compiler
#    MMS clean  -- remove generated files  (e.g. foo.c~)
#
# Parameters:  ALDORROOT
#
#    To override defaults do, e.g.,
#	 MMS/MACRO="ALDORROOT=spad:[local.axl.rs" all
#
##############################################################################

#
# Environment
#
ALDORROOT = axiomxl_root:[base.axpvms
IncDir	= $(ALDORROOT).include]
LibDir	= $(ALDORROOT).lib]
SrcDir	= axiomxl_root:[version.v32_6a.src]
BinDir	= $(ALDORROOT).bin]

LAXLLIB	= $(LibDir)libaxllib.al
LAXLFOAM	= $(LibDir)libfoam.al
LIBFOAM	= $(LibDir)libfoam.olb

AXLCDB	= ""-W check""
CFLAGS	= /DEBUG/NOOPTIMIZE/PREFIX=ALL/EXTERN=STRICT/DEFINE=(NDEBUG,FOAM_RTS)
# CFLAGS = -O -DNDEBUG -DFOAM_RTS

#
# Object lists
#
AxlObjs	= $(LIBFOAM)(runtime)
CObjs	= $(LIBFOAM)(foam_c) $(LIBFOAM)(output)

#
# Target lists
#
IncTargs = $(IncDir)foam_c.h
LibTargs = $(LIBFOAM) $(LAXLFOAM)

# Don't delete the libraries if a compilation fails.
#.PRECIOUS : $(LibTargs)

#
# generic targets
#
all : $(IncTargs) $(LibTargs)
	@ WRITE SYS$OUTPUT "built ALL"

junk ::
	@ WRITE SYS$OUTPUT "Not implemented for VMS"
	@ ! ls -d $(OKFILES) * | sort | uniq -u

clean ::
	@ WRITE SYS$OUTPUT "Not implemented for VMS"
	@ ! rm -f *~ core


junk ::
	@ WRITE SYS$OUTPUT "Not implemented for VMS"
	@ ! -(cd links ; $(MAKE) junk)

clean ::
	@ WRITE SYS$OUTPUT "Not implemented for VMS"
	@ ! -(cd links ; $(MAKE) clean)


includes : $(IncTargs)

# The doranlib dependency ensures that doranlib gets called.
$(LAXLFOAM) : $(AxlObjs) doranlib
	! doranlib $@
$(LIBFOAM) : $(CObjs) $(AxlObjs) doranlib
	! doranlib $@

doranlib :
	@ WRITE SYS$OUTPUT "RANLIB not needed for VMS"
	@ ! echo -n

#
# Acutally make something
#
$(IncDir)/foam_c.h : foam_c.h
	COPY foam_c.h $(IncDir)/foam_c.h

foam_c $(LIBFOAM)(foam_c) : foam_c.c $(IncTargs)
	CC$(CFLAGS)/OBJECT=$(LibDir)/INCLUDE=($(IncDir),$(SrcDir)) foam_c
	IF F$SEARCH("$(LIBFOAM)") .EQS. "" THEN LIBRARY/CREATE/OBJECT $(LIBFOAM)
	LIBRARY/OBJECT $(LIBFOAM) $(LibDir)foam_c
	DELETE $(LibDir)foam_c.obj;

output $(LIBFOAM)(output) : output.c $(IncTargs)
	CC$(CFLAGS)/OBJECT=$(LibDir)/INCLUDE=($(IncDir),$(SrcDir)) output
	IF F$SEARCH("$(LIBFOAM)") .EQS. "" THEN LIBRARY/CREATE/OBJECT $(LIBFOAM)
	LIBRARY/OBJECT $(LIBFOAM) $(LibDir)output
	DELETE $(LibDir)output.obj;

runtime $(LIBFOAM)(runtime) : runtime.as $(LAXLLIB)
	@$(BinDir)doaxiomxl runtime foam \
		"""-Wruntime"" ""-I$(IncDir)""" "$(AXLCDB)"

