##############################################################################
#
# DESCRIP.MMS
#
# Make program to compile the Foam runtime files shared with the AXIOM-XL compiler.
#
##############################################################################
#
# Targets: all, junk, clean, quick
#
#    MMS all	-- make the basic library for the AXIOM-XL compiler
#    MMS junk	-- list files which are not part of the AXIOM-XL compiler
#    MMS clean -- remove generated files  (e.g. foo.c~)
#
# Parameters:  ALDORROOT
#
#    To override defaults do, e.g.,
#	 MMS/MACRO="ALDORROOT=spad:[local.axl]rs" all
#
##############################################################################
#
# We do not use the compiler archive since these files may be compiled
# with different options, or different compilers.
#
##############################################################################

LN = SET FILE/ENTER=
UNLN = SET FILE/REMOVE
AR = LIBRARY/OBJECT
RM = DELETE

# C flags for building the FOAM run time system. -DSTO_TAG is for GC.
CFLAGS = /OPTIMIZE/DEFINE=(NDEBUG,STO_TAG,FOAM_RTS)/PREFIX=ALL/EXTERNAL=STRICT

#
# Environment
#
ALDORROOT = axiomxl_root:[base.axpvms
IncDir	= $(ALDORROOT).include]
LibDir	= $(ALDORROOT).lib]
SRC     = [---.src]
LIBFOAM	= $(LibDir)libfoam.olb

#
# File Lists
#
PORTH0        = axlport.h  platform.h cconfig.h
STDCH0        = assert.h0 ctype.h0 errno.h0  float.h0  limits.h0 \
		locale.h0 math.h0  setjmp.h0 signal.h0 stdarg.h0 \
		stddef.h0 stdio.h0 stdlib.h0 string.h0 time.h0
OPSYSH0       = os_cms.c os_dos.c os_os2.c os_unix.c os_vms.c
FOAMHX        =	axlgen.h axlgen0.h debug.h fluid.h format.h test.h

FOAMC	      = stdc.c cport.c opsys.c btree.c store.c bigint.c util.c
FOAMCH	      = stdc.h cport.h opsys.h btree.h store.h bigint.h util.h
FOAMH         = $(PORTH0) $(STDCH0) $(OPSYSH0) $(FOAMCH) $(FOAMHX)

COMMONFILES   = $(FOAMH) $(FOAMC)
OKFILES       = descrip.mms $(COMMONFILES)

OBJECTS       = $(LIBFOAM)(stdc)  $(LIBFOAM)(cport) $(LIBFOAM)(opsys)  \
		$(LIBFOAM)(btree) $(LIBFOAM)(store) $(LIBFOAM)(bigint) \
		$(LIBFOAM)(util)

# Don't delete the library if a compilation fails.
# .PRECIOUS : $(LIBFOAM)

#
# Generic rules
#
all : $(COMMONFILES) $(LIBFOAM)
	@ WRITE SYS$OUTPUT "built $@"

junk :
	@ WRITE SYS$OUTPUT "Not implemented for VMS"
	@ ! ls -d $(OKFILES) * | sort | uniq -u

clean :
	@ $(UNLN) *.c;*,*.h*;*
	@ PURGE/LOG

#
# Rules to get the common source files (as links or copies)
#
axlport.h :	$(SRC)axlport.h
	$(LN)[]$@ $?
platform.h :	$(SRC)platform.h
	$(LN)[]$@ $?
cconfig.h :	$(SRC)cconfig.h
	$(LN)[]$@ $?

assert.h0 :	$(SRC)assert.h0
	$(LN)[]$@ $?
ctype.h0 :	$(SRC)ctype.h0
	$(LN)[]$@ $?
errno.h0 :	$(SRC)errno.h0
	$(LN)[]$@ $?
float.h0 :	$(SRC)float.h0
	$(LN)[]$@ $?
limits.h0 :	$(SRC)limits.h0
	$(LN)[]$@ $?
locale.h0 :	$(SRC)locale.h0
	$(LN)[]$@ $?
math.h0 :	$(SRC)math.h0
	$(LN)[]$@ $?
setjmp.h0 :	$(SRC)setjmp.h0
	$(LN)[]$@ $?
signal.h0 :	$(SRC)signal.h0
	$(LN)[]$@ $?
stdarg.h0 :	$(SRC)stdarg.h0
	$(LN)[]$@ $?
stddef.h0 :	$(SRC)stddef.h0
	$(LN)[]$@ $?
stdio.h0 :	$(SRC)stdio.h0
	$(LN)[]$@ $?
stdlib.h0 :	$(SRC)stdlib.h0
	$(LN)[]$@ $?
string.h0 :	$(SRC)string.h0
	$(LN)[]$@ $?
time.h0 :	$(SRC)time.h0
	$(LN)[]$@ $?

os_cms.c :	$(SRC)os_cms.c
	$(LN)[]$@ $?
os_dos.c :	$(SRC)os_dos.c
	$(LN)[]$@ $?
os_os2.c :	$(SRC)os_os2.c
	$(LN)[]$@ $?
os_unix.c :	$(SRC)os_unix.c
	$(LN)[]$@ $?
os_vms.c :	$(SRC)os_vms.c
	$(LN)[]$@ $?

axlgen.h :	$(SRC)axlgen.h
	$(LN)[]$@ $?
axlgen0.h :	$(SRC)axlgen0.h
	$(LN)[]$@ $?
debug.h :	$(SRC)debug.h
	$(LN)[]$@ $?
fluid.h :	$(SRC)fluid.h
	$(LN)[]$@ $?
format.h :	$(SRC)format.h
	$(LN)[]$@ $?
test.h : 	$(SRC)test.h
	$(LN)[]$@ $?

stdc.h : 	$(SRC)stdc.h
	$(LN)[]$@ $?
cport.h :	$(SRC)cport.h
	$(LN)[]$@ $?
opsys.h :	$(SRC)opsys.h
	$(LN)[]$@ $?
btree.h :	$(SRC)btree.h
	$(LN)[]$@ $?
store.h :	$(SRC)store.h
	$(LN)[]$@ $?
bigint.h :	$(SRC)bigint.h
	$(LN)[]$@ $?
util.h : 	$(SRC)util.h
	$(LN)[]$@ $?

stdc.c : 	$(SRC)stdc.c
	$(LN)[]$@ $?
cport.c :	$(SRC)cport.c
	$(LN)[]$@ $?
opsys.c :	$(SRC)opsys.c
	$(LN)[]$@ $?
btree.c :	$(SRC)btree.c
	$(LN)[]$@ $?
store.c :	$(SRC)store.c
	$(LN)[]$@ $?
bigint.c :	$(SRC)bigint.c
	$(LN)[]$@ $?
util.c : 	$(SRC)util.c
	$(LN)[]$@ $?

#
# Rules to compile the common files
#

# The doranlib dependency ensures that doranlib gets called.
$(LIBFOAM) : $(OBJECTS)
	@ WRITE SYS$OUTPUT "built $@"

$(LIBFOAM)(stdc) :   stdc.c   $(PORTH0) $(STDCH0)
	@ src = F$ENVIRONMENT("DEFAULT")
	@ SET DEFAULT $(LibDir)
	@ WRITE SYS$OUTPUT "CC$(CFLAGS)/INCLUDE=$(IncDir) ''src'stdc"
	@ CC$(CFLAGS)/INCLUDE=$(IncDir) 'src'stdc
	@ $(AR) $(LIBFOAM) stdc
	@ $(RM) stdc.obj;
	@ SET DEFAULT 'src'

$(LIBFOAM)(cport) :  cport.c  $(PORTH0) $(STDCH0)
	@ src = F$ENVIRONMENT("DEFAULT")
	@ SET DEFAULT $(LibDir)
	@ WRITE SYS$OUTPUT "CC$(CFLAGS)/INCLUDE=$(IncDir) ''src'cport"
	@ CC$(CFLAGS)/INCLUDE=$(IncDir) 'src'cport
	@ $(AR) $(LIBFOAM) cport
	@ $(RM) cport.obj;
	@ SET DEFAULT 'src'

$(LIBFOAM)(opsys) :  opsys.c  $(PORTH0) $(STDCH0) $(OPSYSH0)
	@ src = F$ENVIRONMENT("DEFAULT")
	@ SET DEFAULT $(LibDir)
	@ WRITE SYS$OUTPUT "CC$(CFLAGS)/INCLUDE=$(IncDir) ''src'opsys"
	@ CC$(CFLAGS)/INCLUDE=$(IncDir) 'src'opsys
	@ $(AR) $(LIBFOAM) opsys
	@ $(RM) opsys.obj;
	@ SET DEFAULT 'src'

$(LIBFOAM)(btree) :  btree.c  $(FOAMH)
	@ src = F$ENVIRONMENT("DEFAULT")
	@ SET DEFAULT $(LibDir)
	@ WRITE SYS$OUTPUT "CC$(CFLAGS)/INCLUDE=$(IncDir) ''src'btree"
	@ CC$(CFLAGS)/INCLUDE=$(IncDir) 'src'btree
	@ $(AR) $(LIBFOAM) btree
	@ $(RM) btree.obj;
	@ SET DEFAULT 'src'

$(LIBFOAM)(store) :  store.c  $(FOAMH)
	@ src = F$ENVIRONMENT("DEFAULT")
	@ SET DEFAULT $(LibDir)
	@ WRITE SYS$OUTPUT "CC$(CFLAGS)/INCLUDE=$(IncDir) ''src'store"
	@ CC$(CFLAGS)/INCLUDE=$(IncDir) 'src'store
	@ $(AR) $(LIBFOAM) store
	@ $(RM) store.obj;
	@ SET DEFAULT 'src'

$(LIBFOAM)(bigint) : bigint.c $(FOAMH)
	@ src = F$ENVIRONMENT("DEFAULT")
	@ SET DEFAULT $(LibDir)
	@ WRITE SYS$OUTPUT "CC$(CFLAGS)/INCLUDE=$(IncDir) ''src'bigint"
	@ CC$(CFLAGS)/INCLUDE=$(IncDir) 'src'bigint
	@ $(AR) $(LIBFOAM) bigint
	@ $(RM) bigint.obj;
	@ SET DEFAULT 'src'

$(LIBFOAM)(util) :   util.c   $(FOAMH)
	@ src = F$ENVIRONMENT("DEFAULT")
	@ SET DEFAULT $(LibDir)
	@ WRITE SYS$OUTPUT "CC$(CFLAGS)/INCLUDE=$(IncDir) ''src'util"
	@ CC$(CFLAGS)/INCLUDE=$(IncDir) 'src'util
	@ $(AR) $(LIBFOAM) util
	@ $(RM) util.obj;
	@ SET DEFAULT 'src'

