#!/bin/sh
###############################################################################
# Creates the lib files to be used with Visual C compiler from al aldor 
# portable libraries
#
# Usage: al2lib <aldor_library> <lib_name>
###############################################################################

usage()
{
	name=`basename $0`
	echo "Creates lib files from aldor portable library files"
	echo "Usage: $name <aldor_library> <lib_name>"
}

filesao=`ar t $1`
fileso=`echo $filesao|sed -e"s/\.ao/.o/g"`
filesobj=`echo $filesao|sed -e"s/\.ao/.obj/g"`

for i in $filesao; do
	ar x $1 $i
	echo aldor.sh -Q5 -Qinline-all -Csys=win32msvc -fo $i
	aldor.sh -Q5 -Qinline-all -Csys=win32msvc -fo $i
	rm $i
done

if [ "$1" = "libaldor.al" ]; then
	ar x libaldor.a sal_util.o
	mv sal_util.o sal_util.obj
	filesobj=" sal_util.obj $filesobj"
fi

if [ "$1" = "libaxllib.al" ]; then
	ar x libaxllib.a mndWrite.o
	mv mndWrite.o mndWrite.obj
	filesobj=" mndWrite.obj $filesobj"
fi

echo lib -nologo -out:$2 $filesobj
lib -nologo -out:$2 $filesobj

rm -f $filesobj

