----------------------------- sit_primes.as ----------------------------------
--
-- Hard-coded tables of primes of different sizes
--
-- Copyright (c) Manuel Bronstein 1995
-- Copyright (c) INRIA 1999, Version 0.1.12
-- Logiciel Sum^it INRIA 1999, dans sa version 0.1.12
-- Copyright (c) Swiss Federal Polytechnic Institute Zurich, 1995-97
-----------------------------------------------------------------------------

-- The current sizes are small, 13, 15, 27, 31 and 63 bits

#include "algebra"

macro Z	== MachineInteger;

PrimesSmall: PrimeTable == add {
	import from Z;
	-- the first 1000 odd primes
	primes:Array Z == [_
		3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,_
		61,67,71,73,79,83,89,97,101,103,107,109,113,127,131,137,139,_
		149,151,157,163,167,173,179,181,191,193,197,199,211,223,227,_
		229,233,239,241,251,257,263,269,271,277,281,283,293,307,311,_
		313,317,331,337,347,349,353,359,367,373,379,383,389,397,401,_
		409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,_
		499,503,509,521,523,541,547,557,563,569,571,577,587,593,599,_
		601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,_
		691,701,709,719,727,733,739,743,751,757,761,769,773,787,797,_
		809,811,821,823,827,829,839,853,857,859,863,877,881,883,887,_
		907,911,919,929,937,941,947,953,967,971,977,983,991,997,1009,_
		1013,1019,1021,1031,1033,1039,1049,1051,1061,1063,1069,1087,_
		1091,1093,1097,1103,1109,1117,1123,1129,1151,1153,1163,1171,_
		1181,1187,1193,1201,1213,1217,1223,1229,1231,1237,1249,1259,_
		1277,1279,1283,1289,1291,1297,1301,1303,1307,1319,1321,1327,_
		1361,1367,1373,1381,1399,1409,1423,1427,1429,1433,1439,1447,_
		1451,1453,1459,1471,1481,1483,1487,1489,1493,1499,1511,1523,_
		1531,1543,1549,1553,1559,1567,1571,1579,1583,1597,1601,1607,_
		1609,1613,1619,1621,1627,1637,1657,1663,1667,1669,1693,1697,_
		1699,1709,1721,1723,1733,1741,1747,1753,1759,1777,1783,1787,_
		1789,1801,1811,1823,1831,1847,1861,1867,1871,1873,1877,1879,_
		1889,1901,1907,1913,1931,1933,1949,1951,1973,1979,1987,1993,_
		1997,1999,2003,2011,2017,2027,2029,2039,2053,2063,2069,2081,_
		2083,2087,2089,2099,2111,2113,2129,2131,2137,2141,2143,2153,_
		2161,2179,2203,2207,2213,2221,2237,2239,2243,2251,2267,2269,_
		2273,2281,2287,2293,2297,2309,2311,2333,2339,2341,2347,2351,_
		2357,2371,2377,2381,2383,2389,2393,2399,2411,2417,2423,2437,_
		2441,2447,2459,2467,2473,2477,2503,2521,2531,2539,2543,2549,_
		2551,2557,2579,2591,2593,2609,2617,2621,2633,2647,2657,2659,_
		2663,2671,2677,2683,2687,2689,2693,2699,2707,2711,2713,2719,_
		2729,2731,2741,2749,2753,2767,2777,2789,2791,2797,2801,2803,_
		2819,2833,2837,2843,2851,2857,2861,2879,2887,2897,2903,2909,_
		2917,2927,2939,2953,2957,2963,2969,2971,2999,3001,3011,3019,_
		3023,3037,3041,3049,3061,3067,3079,3083,3089,3109,3119,3121,_
		3137,3163,3167,3169,3181,3187,3191,3203,3209,3217,3221,3229,_
		3251,3253,3257,3259,3271,3299,3301,3307,3313,3319,3323,3329,_
		3331,3343,3347,3359,3361,3371,3373,3389,3391,3407,3413,3433,_
		3449,3457,3461,3463,3467,3469,3491,3499,3511,3517,3527,3529,_
		3533,3539,3541,3547,3557,3559,3571,3581,3583,3593,3607,3613,_
		3617,3623,3631,3637,3643,3659,3671,3673,3677,3691,3697,3701,_
		3709,3719,3727,3733,3739,3761,3767,3769,3779,3793,3797,3803,_
		3821,3823,3833,3847,3851,3853,3863,3877,3881,3889,3907,3911,_
		3917,3919,3923,3929,3931,3943,3947,3967,3989,4001,4003,4007,_
		4013,4019,4021,4027,4049,4051,4057,4073,4079,4091,4093,4099,_
		4111,4127,4129,4133,4139,4153,4157,4159,4177,4201,4211,4217,_
		4219,4229,4231,4241,4243,4253,4259,4261,4271,4273,4283,4289,_
		4297,4327,4337,4339,4349,4357,4363,4373,4391,4397,4409,4421,_
		4423,4441,4447,4451,4457,4463,4481,4483,4493,4507,4513,4517,_
		4519,4523,4547,4549,4561,4567,4583,4591,4597,4603,4621,4637,_
		4639,4643,4649,4651,4657,4663,4673,4679,4691,4703,4721,4723,_
		4729,4733,4751,4759,4783,4787,4789,4793,4799,4801,4813,4817,_
		4831,4861,4871,4877,4889,4903,4909,4919,4931,4933,4937,4943,_
		4951,4957,4967,4969,4973,4987,4993,4999,5003,5009,5011,5021,_
		5023,5039,5051,5059,5077,5081,5087,5099,5101,5107,5113,5119,_
		5147,5153,5167,5171,5179,5189,5197,5209,5227,5231,5233,5237,_
		5261,5273,5279,5281,5297,5303,5309,5323,5333,5347,5351,5381,_
		5387,5393,5399,5407,5413,5417,5419,5431,5437,5441,5443,5449,_
		5471,5477,5479,5483,5501,5503,5507,5519,5521,5527,5531,5557,_
		5563,5569,5573,5581,5591,5623,5639,5641,5647,5651,5653,5657,_
		5659,5669,5683,5689,5693,5701,5711,5717,5737,5741,5743,5749,_
		5779,5783,5791,5801,5807,5813,5821,5827,5839,5843,5849,5851,_
		5857,5861,5867,5869,5879,5881,5897,5903,5923,5927,5939,5953,_
		5981,5987,6007,6011,6029,6037,6043,6047,6053,6067,6073,6079,_
		6089,6091,6101,6113,6121,6131,6133,6143,6151,6163,6173,6197,_
		6199,6203,6211,6217,6221,6229,6247,6257,6263,6269,6271,6277,_
		6287,6299,6301,6311,6317,6323,6329,6337,6343,6353,6359,6361,_
		6367,6373,6379,6389,6397,6421,6427,6449,6451,6469,6473,6481,_
		6491,6521,6529,6547,6551,6553,6563,6569,6571,6577,6581,6599,_
		6607,6619,6637,6653,6659,6661,6673,6679,6689,6691,6701,6703,_
		6709,6719,6733,6737,6761,6763,6779,6781,6791,6793,6803,6823,_
		6827,6829,6833,6841,6857,6863,6869,6871,6883,6899,6907,6911,_
		6917,6947,6949,6959,6961,6967,6971,6977,6983,6991,6997,7001,_
		7013,7019,7027,7039,7043,7057,7069,7079,7103,7109,7121,7127,_
		7129,7151,7159,7177,7187,7193,7207,7211,7213,7219,7229,7237,_
		7243,7247,7253,7283,7297,7307,7309,7321,7331,7333,7349,7351,_
		7369,7393,7411,7417,7433,7451,7457,7459,7477,7481,7487,7489,_
		7499,7507,7517,7523,7529,7537,7541,7547,7549,7559,7561,7573,_
		7577,7583,7589,7591,7603,7607,7621,7639,7643,7649,7669,7673,_
		7681,7687,7691,7699,7703,7717,7723,7727,7741,7753,7757,7759,_
		7789,7793,7817,7823,7829,7841,7853,7867,7873,7877,7879,7883,_
		7901,7907,7919,7927];

	-- primitive roots for the above primes
	roots:Array Z == [
		2,2,3,2,2,3,2,5,2,3,2,6,3,5,2,2,2,2,7,5,3,2,3,5,_
		2,5,2,6,3,3,2,3,2,2,6,5,2,5,2,2,2,19,5,2,3,2,3,2,6,3,7,7,6,3,_
		5,2,6,5,3,3,2,5,17,10,2,3,10,2,2,3,7,6,2,2,5,2,5,3,21,2,2,7,5,_
		15,2,3,13,2,3,2,13,3,2,7,5,2,3,2,2,2,2,2,3,3,5,2,3,7,7,3,2,3,_
		2,3,3,11,5,2,2,2,5,2,5,3,2,2,11,5,6,3,5,3,2,6,11,2,2,2,3,3,2,_
		3,2,2,11,2,3,2,5,2,3,2,5,2,17,7,3,5,2,2,3,5,6,3,5,6,7,11,3,2,_
		10,14,5,3,3,7,2,3,6,3,2,5,3,5,2,2,2,11,17,5,5,2,7,2,3,11,2,3,_
		5,2,3,2,7,2,2,3,2,6,2,10,2,6,2,13,13,3,3,5,2,2,13,3,3,2,6,3,7,_
		3,2,2,3,6,3,2,5,14,2,2,11,2,2,5,2,3,19,3,2,3,5,11,3,5,7,3,2,2,_
		3,2,11,3,2,2,2,3,3,3,3,3,2,2,2,7,6,5,10,2,6,11,6,5,3,5,2,2,14,_
		10,2,6,3,2,2,3,2,5,2,3,2,2,2,5,2,3,5,3,5,2,2,7,2,5,2,3,2,5,7,_
		2,7,5,3,2,10,2,3,3,23,7,5,5,2,2,2,3,2,7,2,2,3,7,19,2,5,2,3,2,_
		2,7,3,13,2,2,5,3,5,2,3,11,6,3,5,2,6,5,2,2,5,2,3,17,2,2,5,2,6,_
		2,2,7,7,3,5,2,3,3,3,2,5,7,2,2,5,19,2,2,2,7,5,3,3,3,2,6,3,3,3,_
		2,6,2,3,2,2,5,2,2,2,11,2,7,5,3,5,2,5,5,2,13,2,2,3,10,17,14,2,_
		2,5,2,3,11,6,2,6,2,3,6,7,7,3,3,5,7,7,2,11,2,3,5,10,6,6,2,3,3,_
		3,2,6,2,10,6,2,3,3,5,2,11,22,2,5,3,3,5,2,5,3,7,2,3,2,2,2,2,7,_
		2,5,17,2,2,7,2,2,3,2,2,3,3,5,2,3,5,15,2,2,2,13,5,2,2,5,2,2,7,_
		3,2,7,3,5,7,2,5,2,2,3,3,3,5,2,2,5,2,13,11,2,13,2,3,2,3,2,3,2,_
		6,2,3,2,5,2,2,2,3,3,10,5,3,11,2,2,2,12,5,13,2,2,5,2,3,5,11,6,_
		3,2,2,3,3,2,2,2,2,7,5,2,3,5,3,3,10,2,2,2,2,14,2,3,3,3,21,3,2,_
		3,5,3,2,2,2,7,2,3,5,2,6,11,3,5,11,5,2,2,2,3,5,3,3,15,3,3,11,2,_
		5,6,2,17,5,19,3,6,2,2,3,7,7,2,3,3,11,11,2,3,3,6,13,6,2,3,7,6,_
		2,5,11,2,2,5,3,2,3,2,3,3,11,2,2,2,3,5,2,6,2,19,3,2,5,6,2,2,2,_
		7,17,2,7,10,3,2,3,7,7,3,5,2,5,2,3,11,3,2,3,7,3,5,3,3,3,5,3,2,_
		7,7,2,3,2,2,3,2,13,11,5,10,2,2,13,2,6,11,5,7,14,3,2,5,3,2,3,2,_
		11,2,2,19,2,5,2,10,2,2,7,6,3,5,2,6,2,6,2,3,2,7,3,5,2,11,31,3,_
		5,2,5,2,7,3,2,3,2,2,5,5,5,2,2,10,17,3,7,2,3,7,2,5,5,3,3,2,2,3,_
		2,2,5,3,2,5,3,5,2,11,2,7,2,10,7,2,2,3,10,3,3,13,19,3,2,2,2,2,_
		6,3,3,3,2,3,7,2,6,7,2,17,10,5,3,3,5,14,13,3,2,2,2,2,6,5,7,3,2,_
		2,5,2,11,2,3,3,2,2,2,7,10,2,3,2,2,3,22,3,5,2,3,2,2,2,7,2,2,2,_
		7,13,5,2,3,5,6,5,3,2,2,2,3,2,5,2,7,5,2,3,5,7,7,3,10,2,3,3,2,5,_
		2,2,2,2,5,2,2,5,2,6,7,2,6,2,6,7,5,2,5,3,2,3,2,2,6,5,7,2,2,2,2,_
		3,7,2,2,2,13,13,2,3,5,2,6,2,5,2,7,2,3,2,3,17,6,2,3,5,2,3,5,7,_
		10,2,3,2,3,3,5,2,12,2,3,5,2,3,2,2,2,7,3];

	-- small primes of the form 2^n k + 1 for n = 1,2,...,
	fourier:Array Z == [];
}

Primes13: PrimeTable == add {
	import from Z;
	-- the last 200 13-bit primes
	primes:Array Z == [_
		6361, 6367, 6373, 6379, 6389, 6397, 6421, 6427, 6449, 6451,_
		6469, 6473, 6481, 6491, 6521, 6529, 6547, 6551, 6553, 6563,_
		6569, 6571, 6577, 6581, 6599, 6607, 6619, 6637, 6653, 6659,_
		6661, 6673, 6679, 6689, 6691, 6701, 6703, 6709, 6719, 6733,_
		6737, 6761, 6763, 6779, 6781, 6791, 6793, 6803, 6823, 6827,_
		6829, 6833, 6841, 6857, 6863, 6869, 6871, 6883, 6899, 6907,_
		6911, 6917, 6947, 6949, 6959, 6961, 6967, 6971, 6977, 6983,_
		6991, 6997, 7001, 7013, 7019, 7027, 7039, 7043, 7057, 7069,_
		7079, 7103, 7109, 7121, 7127, 7129, 7151, 7159, 7177, 7187,_
		7193, 7207, 7211, 7213, 7219, 7229, 7237, 7243, 7247, 7253,_
		7283, 7297, 7307, 7309, 7321, 7331, 7333, 7349, 7351, 7369,_
		7393, 7411, 7417, 7433, 7451, 7457, 7459, 7477, 7481, 7487,_
		7489, 7499, 7507, 7517, 7523, 7529, 7537, 7541, 7547, 7549,_
		7559, 7561, 7573, 7577, 7583, 7589, 7591, 7603, 7607, 7621,_
		7639, 7643, 7649, 7669, 7673, 7681, 7687, 7691, 7699, 7703,_
		7717, 7723, 7727, 7741, 7753, 7757, 7759, 7789, 7793, 7817,_
		7823, 7829, 7841, 7853, 7867, 7873, 7877, 7879, 7883, 7901,_
		7907, 7919, 7927, 7933, 7937, 7949, 7951, 7963, 7993, 8009,_
		8011, 8017, 8039, 8053, 8059, 8069, 8081, 8087, 8089, 8093,_
		8101, 8111, 8117, 8123, 8147, 8161, 8167, 8171, 8179, 8191];

	-- 13-bit primes of the form 2^n k + 1 for n = 1,2,...,
	fourier:Array Z == [];

	-- primitive 2^n-th roots of unity for the above fourier primes
	roots:Array Z == [];
}

Primes15: PrimeTable == add {
	import from Z;
	-- the last 200 15-bit primes
	primes:Array Z == [_
		30707, 30713, 30727, 30757, 30763, 30773, 30781, 30803, 30809,_
		30817, 30829, 30839, 30841, 30851, 30853, 30859, 30869, 30871,_
		30881, 30893, 30911, 30931, 30937, 30941, 30949, 30971, 30977,_
		30983, 31013, 31019, 31033, 31039, 31051, 31063, 31069, 31079,_
		31081, 31091, 31121, 31123, 31139, 31147, 31151, 31153, 31159,_
		31177, 31181, 31183, 31189, 31193, 31219, 31223, 31231, 31237,_
		31247, 31249, 31253, 31259, 31267, 31271, 31277, 31307, 31319,_
		31321, 31327, 31333, 31337, 31357, 31379, 31387, 31391, 31393,_
		31397, 31469, 31477, 31481, 31489, 31511, 31513, 31517, 31531,_
		31541, 31543, 31547, 31567, 31573, 31583, 31601, 31607, 31627,_
		31643, 31649, 31657, 31663, 31667, 31687, 31699, 31721, 31723,_
		31727, 31729, 31741, 31751, 31769, 31771, 31793, 31799, 31817,_
		31847, 31849, 31859, 31873, 31883, 31891, 31907, 31957, 31963,_
		31973, 31981, 31991, 32003, 32009, 32027, 32029, 32051, 32057,_
		32059, 32063, 32069, 32077, 32083, 32089, 32099, 32117, 32119,_
		32141, 32143, 32159, 32173, 32183, 32189, 32191, 32203, 32213,_
		32233, 32237, 32251, 32257, 32261, 32297, 32299, 32303, 32309,_
		32321, 32323, 32327, 32341, 32353, 32359, 32363, 32369, 32371,_
		32377, 32381, 32401, 32411, 32413, 32423, 32429, 32441, 32443,_
		32467, 32479, 32491, 32497, 32503, 32507, 32531, 32533, 32537,_
		32561, 32563, 32569, 32573, 32579, 32587, 32603, 32609, 32611,_
		32621, 32633, 32647, 32653, 32687, 32693, 32707, 32713, 32717,_
		32719, 32749];

	-- 15-bit primes of the form 2^n k + 1 for n = 1,2,...,12
	fourier:Array Z == [_
		30707, 30757, 30713, 31121, 30817, 32321, 31873, 31489, 32257,_
		25601, 18433, 12289];

	-- primitive 2^n-th roots of unity for the above fourier primes
	roots:Array Z == [_
		30706, 11220, 13503,  2272, 14748, 22574, 26607, 22354, 30331,_
		12725, 17660, 1331];
}

Primes27: PrimeTable == add {
	import from Z;
	-- the last 300 27-bit primes
	primes:Array Z == [_
		134212303, 134212349, 134212367, 134212369, 134212381,_
		134212387, 134212451, 134212469, 134212499, 134212517,_
		134212543, 134212553, 134212571, 134212607, 134212621,_
		134212633, 134212643, 134212651, 134212657, 134212679,_
		134212691, 134212693, 134212697, 134212703, 134212709,_
		134212769, 134212781, 134212829, 134212849, 134212861,_
		134212913, 134212921, 134212927, 134212937, 134212961,_
		134212973, 134212987, 134212999, 134213039, 134213047,_
		134213063, 134213077, 134213081, 134213083, 134213087,_
		134213111, 134213231, 134213239, 134213267, 134213269,_
		134213273, 134213293, 134213297, 134213311, 134213323,_
		134213327, 134213329, 134213333, 134213357, 134213381,_
		134213399, 134213411, 134213413, 134213423, 134213447,_
		134213483, 134213489, 134213507, 134213531, 134213567,_
		134213581, 134213609, 134213617, 134213647, 134213683,_
		134213699, 134213713, 134213719, 134213747, 134213753,_
		134213767, 134213773, 134213789, 134213803, 134213819,_
		134213843, 134213851, 134213857, 134213873, 134213887,_
		134213899, 134213903, 134213921, 134213941, 134213971,_
		134213983, 134214007, 134214011, 134214023, 134214083,_
		134214089, 134214109, 134214151, 134214173, 134214181,_
		134214191, 134214209, 134214229, 134214251, 134214257,_
		134214259, 134214263, 134214277, 134214317, 134214343,_
		134214389, 134214413, 134214419, 134214449, 134214463,_
		134214491, 134214517, 134214527, 134214529, 134214539,_
		134214551, 134214571, 134214583, 134214629, 134214649,_
		134214667, 134214671, 134214673, 134214749, 134214761,_
		134214763, 134214767, 134214781, 134214791, 134214809,_
		134214827, 134214833, 134214851, 134214877, 134214887,_
		134214889, 134214893, 134214931, 134214973, 134214979,_
		134214989, 134215001, 134215007, 134215009, 134215013,_
		134215019, 134215049, 134215057, 134215111, 134215121,_
		134215141, 134215199, 134215229, 134215231, 134215241,_
		134215253, 134215261, 134215307, 134215349, 134215363,_
		134215379, 134215429, 134215441, 134215447, 134215463,_
		134215483, 134215507, 134215553, 134215559, 134215573,_
		134215577, 134215583, 134215589, 134215607, 134215643,_
		134215681, 134215693, 134215703, 134215721, 134215723,_
		134215727, 134215747, 134215751, 134215801, 134215813,_
		134215817, 134215819, 134215831, 134215841, 134215843,_
		134215847, 134215931, 134215999, 134216009, 134216011,_
		134216021, 134216039, 134216041, 134216051, 134216053,_
		134216059, 134216077, 134216113, 134216119, 134216129,_
		134216141, 134216167, 134216179, 134216189, 134216219,_
		134216227, 134216231, 134216249, 134216261, 134216347,_
		134216359, 134216389, 134216393, 134216419, 134216447,_
		134216461, 134216473, 134216491, 134216503, 134216543,_
		134216557, 134216573, 134216597, 134216603, 134216609,_
		134216629, 134216647, 134216729, 134216737, 134216759,_
		134216777, 134216783, 134216791, 134216801, 134216807,_
		134216827, 134216837, 134216861, 134216867, 134216869,_
		134216881, 134216899, 134216911, 134216933, 134216939,_
		134216947, 134216987, 134217001, 134217043, 134217047,_
		134217049, 134217079, 134217089, 134217103, 134217131,_
		134217157, 134217163, 134217173, 134217199, 134217221,_
		134217247, 134217257, 134217277, 134217301, 134217323,_
		134217353, 134217361, 134217367, 134217401, 134217403,_
		134217409, 134217437, 134217439, 134217467, 134217487,_
		134217493, 134217497, 134217509, 134217529, 134217541,_
		134217593, 134217613, 134217617, 134217649, 134217689];

	-- 27-bit primes of the form 2^n k + 1 for n = 1,2,...,
	fourier:Array Z == [];

	-- primitive 2^n-th roots of unity for the above fourier primes
	roots:Array Z == [];
}

Primes31: PrimeTable == add {
	import from Z;
	-- the last 200 31-bit primes
	primes:Array Z == [_
		2147479273, 2147479307, 2147479339, 2147479349, 2147479361,_
		2147479381, 2147479403, 2147479421, 2147479447, 2147479489,_
		2147479507, 2147479513, 2147479517, 2147479531, 2147479547,_
		2147479549, 2147479573, 2147479589, 2147479601, 2147479619,_
		2147479637, 2147479643, 2147479657, 2147479681, 2147479751,_
		2147479753, 2147479757, 2147479781, 2147479787, 2147479819,_
		2147479823, 2147479879, 2147479891, 2147479897, 2147479907,_
		2147479937, 2147479991, 2147480009, 2147480011, 2147480039,_
		2147480161, 2147480197, 2147480207, 2147480219, 2147480227,_
		2147480297, 2147480299, 2147480311, 2147480327, 2147480369,_
		2147480429, 2147480437, 2147480459, 2147480471, 2147480507,_
		2147480519, 2147480527, 2147480551, 2147480591, 2147480611,_
		2147480623, 2147480641, 2147480651, 2147480677, 2147480683,_
		2147480707, 2147480723, 2147480743, 2147480747, 2147480791,_
		2147480837, 2147480843, 2147480849, 2147480893, 2147480897,_
		2147480899, 2147480921, 2147480927, 2147480941, 2147480957,_
		2147480969, 2147480971, 2147480989, 2147481019, 2147481031,_
		2147481053, 2147481071, 2147481139, 2147481143, 2147481151,_
		2147481173, 2147481179, 2147481199, 2147481209, 2147481247,_
		2147481263, 2147481269, 2147481283, 2147481311, 2147481317,_
		2147481337, 2147481353, 2147481359, 2147481367, 2147481373,_
		2147481487, 2147481491, 2147481499, 2147481509, 2147481529,_
		2147481563, 2147481571, 2147481629, 2147481673, 2147481793,_
		2147481797, 2147481811, 2147481827, 2147481863, 2147481883,_
		2147481893, 2147481899, 2147481901, 2147481907, 2147481937,_
		2147481949, 2147481967, 2147481997, 2147482021, 2147482063,_
		2147482081, 2147482091, 2147482093, 2147482121, 2147482223,_
		2147482231, 2147482237, 2147482273, 2147482291, 2147482327,_
		2147482343, 2147482349, 2147482361, 2147482367, 2147482409,_
		2147482417, 2147482481, 2147482501, 2147482507, 2147482577,_
		2147482583, 2147482591, 2147482621, 2147482661, 2147482663,_
		2147482681, 2147482693, 2147482697, 2147482739, 2147482763,_
		2147482801, 2147482811, 2147482817, 2147482819, 2147482859,_
		2147482867, 2147482873, 2147482877, 2147482921, 2147482937,_
		2147482943, 2147482949, 2147482951, 2147483029, 2147483033,_
		2147483053, 2147483059, 2147483069, 2147483077, 2147483123,_
		2147483137, 2147483171, 2147483179, 2147483237, 2147483249,_
		2147483269, 2147483323, 2147483353, 2147483399, 2147483423,_
		2147483477, 2147483489, 2147483497, 2147483543, 2147483549,_
		2147483563, 2147483579, 2147483587, 2147483629, 2147483647];

	-- 31-bit primes of the form 2^n k + 1 for n = 1,2,...,19
	fourier:Array Z == [_
		2147481359, 2147481373, 2147481337, 2147483249, 2147482081,_
		2147481793, 2147479937, 2147477249, 2147483137, 2147415041,_
		2147473409, 2147389441, 2147377153, 2147205121, 2146336769,_
		2145976321, 2147352577, 2142502913, 2147481337];

	-- primitive 2^n-th roots of unity for the above fourier primes
	roots:Array Z == [_
		2147481358, 1656763493, 1048073712, 2056890868,  123061290,_
		 198634476, 1036818207, 2074424914,  365034239,  101307741,_
		 383167813,  447825397, 1202012506,  709811861, 1772766431,_
		1861286377, 1615402923, 1483439287, 1691121884];
}

Primes63: PrimeTable == add {
	import from Z;
	-- the last 60 63-bit primes
	primes:Array Z == [_
		9223372036854773477, 9223372036854773489, 9223372036854773507,_
		9223372036854773519, 9223372036854773557, 9223372036854773561,_
		9223372036854773639, 9223372036854773783, 9223372036854773867,_
		9223372036854773899, 9223372036854773953, 9223372036854773977,_
		9223372036854773999, 9223372036854774053, 9223372036854774173,_
		9223372036854774179, 9223372036854774199, 9223372036854774233,_
		9223372036854774247, 9223372036854774257, 9223372036854774277,_
		9223372036854774307, 9223372036854774319, 9223372036854774341,_
		9223372036854774413, 9223372036854774451, 9223372036854774499,_
		9223372036854774509, 9223372036854774511, 9223372036854774559,_
		9223372036854774571, 9223372036854774587, 9223372036854774629,_
		9223372036854774679, 9223372036854774713, 9223372036854774739,_
		9223372036854774797, 9223372036854774893, 9223372036854774917,_
		9223372036854774937, 9223372036854774959, 9223372036854775057,_
		9223372036854775073, 9223372036854775097, 9223372036854775139,_
		9223372036854775159, 9223372036854775181, 9223372036854775259,_
		9223372036854775279, 9223372036854775291, 9223372036854775337,_
		9223372036854775351, 9223372036854775399, 9223372036854775417,_
		9223372036854775421, 9223372036854775433, 9223372036854775507,_
		9223372036854775549, 9223372036854775643, 9223372036854775783];

	-- 63-bit primes of the form 2^n k + 1 for n = 1,2,...,16
	fourier:Array Z == [_
		9223372036854775783, 9223372036854775549, 9223372036854775433,_
		9223372036854775057, 9223372036854775073, 9223372036854773953,_
		9223372036854771841, 9223372036854771457, 9223372036854747649,_
		9223372036854758401, 9223372036854675457, 9223372036854460417,_
		9223372036854374401, 9223372036854497281, 9223372036853235713,_
		9223372036853661697, 9223372036844421121];

	-- primitive 2^n-th roots of unity for the above fourier primes
	 roots:Array Z == [_
		9223372036854775782, 3240558518817831482, 4171426351174236828,_
		1633667126224019131, 4157847666630089467, 2221942928855380634,_
		3538733102255940697, 1716430083025891097, 3345749197117459333,_
		8514983230644668327, 9049461781042640807, 5605891926531706623,_
		1009825714493485787, 3005483215108443779, 5726005320285737278,_
		781480991878226726,  131461279243254895];
}

