# Arch Perl library, Copyright (C) 2004-2005 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::registry;
use base 'AXP::Command';

use Arch::Registry;

sub infoline {
	"provide information about world-wide archives"
}

sub options {
	(
		locations => { sh => 'l', desc => "include archive locations" },
		versions  => { sh => 'v', desc => "include archive versions" },
	)
}

sub registry {
	my $self = shift;
	my $cache_dir = $self->setup_config_dir("registry-cache");

	$self->{registry} ||= Arch::Registry->new->set_web_cache(
		dir => $cache_dir, ttl => 4 * 60 * 60,
	);
	return $self->{registry};
}

sub print_output ($$) {
	my $self = shift;
	my $archive_versions = shift;
	my %opt = %{$self->{options}};

	my $registry = $self->registry;
	my $web_error = $registry->web_error;
	die "Error accessing supermirror: $web_error" if $web_error;

	my $show_locations = $opt{locations};
	my $show_versions  = $opt{versions};
	my $locations = $show_locations? $registry->supermirror_archives: undef;

	foreach my $archive (sort keys %$archive_versions) {
		print "$archive\n";
		print "    ", ($locations->{$archive} || "no-location"), "\n"
			if $show_locations;
		my $versions = $show_versions? $archive_versions->{$archive}: [];
		print "\t$_\n" foreach @$versions;
	}
}

1;
