# these variables are set (and configurable) using "make rpm-dist" procedure
%define ver 0.0.0
%define rel 1
%define c_p --not-used
%define m_p JUST=/an/example

%define _prefix /usr
%define _sourcedir /tmp

Name:      axp
Version:   %ver
Release:   %rel
Vendor:    Mikhael Goikhman <migo@homemail.com>
License:   GPL
Group:     Development/Tools
Summary:   Command line based extension platform for GNU Arch
Source:    http://migo.sixbit.org/software/axp/releases/%name-%version.tar.gz
URL:       http://migo.sixbit.org/software/axp/
Requires:  perl-Arch >= 0.5.1
Requires:  tla >= 1.1, perl >= 5.00503
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-%(%{__id_u} -n)

%description 
AXP stands for Arch eXtension Platform (or Arch eXtended by Perl).
This is a command line tool with a modular, hierarchical and pluggable
command set, that provides additional GNU Arch functionality.

Run 'axp help -r' to see all commands. Some of the notable ones are
'axp triggers', 'axp registry', 'axp revlib', 'axp annotate'.

%define perl_vendorlib %(eval `perl -V:vendorlib`; echo $vendorlib)

%prep
%setup -q

%build

%clean
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=%_prefix DESTDIR=$RPM_BUILD_ROOT WITH_ARCH_PERL=no

mkdir -p $RPM_BUILD_ROOT%perl_vendorlib
mv $RPM_BUILD_ROOT%_datadir/%name/perllib/AXP $RPM_BUILD_ROOT%perl_vendorlib
rmdir $RPM_BUILD_ROOT/%_datadir/%name/perllib

%files
%doc AUTHORS COPYING NEWS README ChangeLog
%doc doc/COMMANDS doc/CodingStyle doc/REQUIREMENTS doc/adding-new-command
%_bindir/*
%_datadir/%name
%perl_vendorlib/AXP

%define date%(env LC_ALL=C date +"%a %b %d %Y")
%changelog
* %{date} Mikhael Goikhman <migo@homemail.com>
- auto build %{PACKAGE_VERSION}
