/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.cache;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nz.net.catalyst.lucene.cache.SearcherCache;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.FSDirectory;

public class IndexSearcherCache
extends SearcherCache {
    protected File m_directory;
    private boolean debug = false;
    private static final Map instances = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexSearcherCache getInstance(File path) throws IOException {
        FSDirectory directory = FSDirectory.getDirectory((File)path, (boolean)false);
        Map map = instances;
        synchronized (map) {
            IndexSearcherCache isc = (IndexSearcherCache)instances.get(directory);
            if (isc == null) {
                isc = new IndexSearcherCache(path);
                instances.put(directory, isc);
            }
            return isc;
        }
    }

    private IndexSearcherCache(File path) throws IOException {
        this.m_directory = path;
    }

    public void setDirectory(File directory) {
        this.m_directory = directory;
    }

    public File getDirectory() {
        return this.m_directory;
    }

    protected boolean isSearcherOld(SearcherCache.CachedSearcher searcher) {
        if (this.debug) {
            System.out.println("is searcher old: " + (this.m_directory.lastModified() > searcher.getCreationTime()));
        }
        return this.m_directory.lastModified() > searcher.getCreationTime();
    }

    protected SearcherCache.CachedSearcher createNewCachedSearcher() throws IOException {
        if (this.debug) {
            System.out.println("new searcher created");
        }
        return new SearcherCache.CachedSearcher(this, (Searcher)new IndexSearcher(IndexReader.open((File)this.m_directory)));
    }
}

