/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import nz.net.catalyst.lucene.testclient.SequentialControl;

public class SequentialClient
implements Runnable {
    String name = "";
    int query_number = 0;
    int delay = 0;

    public SequentialClient(String name, int query_number, int delay) {
        this.name = name;
        this.query_number = query_number;
        this.delay = delay;
    }

    public void run() {
        long tStart = 0L;
        long tOpenedConnection = 0L;
        long tAfterExecuting = 0L;
        long tClosedConnection = 0L;
        while (SequentialControl.run) {
            try {
                String serverOutput;
                tStart = System.currentTimeMillis();
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss S");
                String output = sdf.format(new Date());
                Socket echoSocket = null;
                PrintWriter out = null;
                BufferedReader in = null;
                echoSocket = new Socket("localhost", 22222);
                out = new PrintWriter(echoSocket.getOutputStream(), true);
                in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));
                tOpenedConnection = System.currentTimeMillis();
                String query = SequentialControl.queries[this.query_number];
                output = String.valueOf(output) + "\tThread: " + this.name + " query: " + this.query_number;
                out.println(query);
                BufferedReader br = new BufferedReader(in);
                while ((serverOutput = br.readLine()) != null && !serverOutput.startsWith("END")) {
                    serverOutput.startsWith("Count:");
                }
                tAfterExecuting = System.currentTimeMillis();
                out.close();
                in.close();
                echoSocket.close();
                tClosedConnection = System.currentTimeMillis();
                output = String.valueOf(output) + "\to: " + (tOpenedConnection - tStart);
                output = String.valueOf(output) + "\te: " + (tAfterExecuting - tOpenedConnection);
                output = String.valueOf(output) + "\tc: " + (tClosedConnection - tAfterExecuting);
                output = String.valueOf(output) + "\tt: " + (tAfterExecuting - tStart);
                SequentialControl.threadTime += tAfterExecuting - tStart;
                ++SequentialControl.requestsCompleted;
            }
            catch (Exception e) {
                System.err.println("Thread: " + this.name + ": Couldn't get I/O for the connection or connection dropped.");
                ++SequentialControl.errorCount;
            }
        }
        --SequentialControl.threadsRunning;
    }
}

